/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.event.connection;

import com.lambdaworks.redis.event.connection.ConnectionEvent;
import com.lambdaworks.redis.internal.LettuceAssert;
import java.net.SocketAddress;

abstract class ConnectionEventSupport
implements ConnectionEvent {
    private final SocketAddress local;
    private final SocketAddress remote;

    ConnectionEventSupport(SocketAddress local, SocketAddress remote) {
        LettuceAssert.notNull(local, "local must not be null");
        LettuceAssert.notNull(remote, "remote must not be null");
        this.local = local;
        this.remote = remote;
    }

    @Override
    public SocketAddress localAddress() {
        return this.local;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remote;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        this.appendConnectionId(sb);
        sb.append(']');
        return sb.toString();
    }

    void appendConnectionId(StringBuffer sb) {
        sb.append(this.local);
        sb.append(" -> ").append(this.remote);
    }
}

