/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.partitions;

import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Partitions
implements Collection<RedisClusterNode> {
    private List<RedisClusterNode> partitions = new ArrayList<RedisClusterNode>();
    private static final RedisClusterNode[] EMPTY = new RedisClusterNode[16384];
    private volatile RedisClusterNode[] slotCache = EMPTY;

    public RedisClusterNode getPartitionBySlot(int slot) {
        return this.slotCache[slot];
    }

    public RedisClusterNode getPartitionByNodeId(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition;
        }
        return null;
    }

    public synchronized void updateCache() {
        if (this.partitions.isEmpty()) {
            this.slotCache = EMPTY;
            return;
        }
        RedisClusterNode[] slotCache = new RedisClusterNode[16384];
        for (RedisClusterNode partition : this.partitions) {
            for (Integer integer : partition.getSlots()) {
                slotCache[integer.intValue()] = partition;
            }
        }
        this.slotCache = slotCache;
    }

    @Override
    public Iterator<RedisClusterNode> iterator() {
        return this.partitions.iterator();
    }

    public List<RedisClusterNode> getPartitions() {
        return this.partitions;
    }

    public void addPartition(RedisClusterNode partition) {
        this.slotCache = EMPTY;
        this.partitions.add(partition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ").append(this.partitions);
        return sb.toString();
    }

    @Override
    public int size() {
        return this.getPartitions().size();
    }

    public RedisClusterNode getPartition(int index) {
        return this.getPartitions().get(index);
    }

    public void reload(List<RedisClusterNode> partitions) {
        this.partitions.clear();
        this.partitions.addAll(partitions);
        this.updateCache();
    }

    @Override
    public boolean isEmpty() {
        return this.getPartitions().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getPartitions().contains(o);
    }

    @Override
    public boolean addAll(Collection<? extends RedisClusterNode> c) {
        boolean b = this.partitions.addAll(c);
        this.updateCache();
        return b;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = this.getPartitions().removeAll(c);
        this.updateCache();
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean b = this.getPartitions().retainAll(c);
        this.updateCache();
        return b;
    }

    @Override
    public void clear() {
        this.getPartitions().clear();
        this.updateCache();
    }

    @Override
    public Object[] toArray() {
        return this.getPartitions().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getPartitions().toArray(a);
    }

    @Override
    public boolean add(RedisClusterNode redisClusterNode) {
        boolean add = this.getPartitions().add(redisClusterNode);
        this.updateCache();
        return add;
    }

    @Override
    public boolean remove(Object o) {
        boolean remove = this.getPartitions().remove(o);
        this.updateCache();
        return remove;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getPartitions().containsAll(c);
    }
}

