/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.io.netty.channel.ChannelHandler;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogger;
import com.lambdaworks.io.netty.util.internal.logging.InternalLoggerFactory;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.internal.LettuceSets;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.resource.ClientResources;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.Set;

@ChannelHandler.Sharable
class ClusterNodeCommandHandler<K, V>
extends CommandHandler<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterNodeCommandHandler.class);
    private static final Set<CommandHandler.LifecycleState> CHANNEL_OPEN_STATES = LettuceSets.unmodifiableSet(CommandHandler.LifecycleState.ACTIVATING, CommandHandler.LifecycleState.ACTIVE, CommandHandler.LifecycleState.CONNECTED);
    private final RedisChannelWriter<K, V> clusterChannelWriter;

    public ClusterNodeCommandHandler(ClientOptions clientOptions, ClientResources clientResources, Queue<RedisCommand<K, V, ?>> queue, RedisChannelWriter<K, V> clusterChannelWriter) {
        super(clientOptions, clientResources, queue);
        this.clusterChannelWriter = clusterChannelWriter;
    }

    public void prepareClose() {
        ConnectionWatchdog connectionWatchdog;
        if (this.channel != null && (connectionWatchdog = this.channel.pipeline().get(ConnectionWatchdog.class)) != null) {
            connectionWatchdog.setReconnectSuspended(true);
        }
    }

    @Override
    public void close() {
        logger.debug("{} close()", (Object)this.logPrefix());
        if (this.clusterChannelWriter != null) {
            Collection<RedisCommand<K, V, ?>> commands;
            if (this.isAutoReconnect() && !CHANNEL_OPEN_STATES.contains((Object)this.getState())) {
                commands = this.shiftCommands(this.queue);
                this.retriggerCommands(commands);
            }
            commands = this.shiftCommands(this.commandBuffer);
            this.retriggerCommands(commands);
        }
        super.close();
    }

    protected void retriggerCommands(Collection<RedisCommand<K, V, ?>> commands) {
        for (RedisCommand<K, V, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                this.clusterChannelWriter.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.completeExceptionally(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private Collection<RedisCommand<K, V, ?>> shiftCommands(Collection<RedisCommand<K, V, ?>> source) {
        Object object = this.stateLock;
        synchronized (object) {
            try {
                ArrayList arrayList;
                this.lockWritersExclusive();
                try {
                    arrayList = new ArrayList(source);
                    source.clear();
                }
                catch (Throwable throwable) {
                    source.clear();
                    throw throwable;
                }
                return arrayList;
            }
            finally {
                this.unlockWritersExclusive();
            }
        }
    }

    public boolean isAutoReconnect() {
        return this.clientOptions.isAutoReconnect();
    }
}

