/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.ClusterClientOptions;
import com.lambdaworks.redis.cluster.ClusterCommand;
import com.lambdaworks.redis.cluster.ClusterConnectionProvider;
import com.lambdaworks.redis.cluster.ClusterEventListener;
import com.lambdaworks.redis.cluster.ReadOnlyCommands;
import com.lambdaworks.redis.cluster.SlotHash;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.internal.HostAndPort;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;

class ClusterDistributionChannelWriter<K, V>
implements RedisChannelWriter<K, V> {
    private final RedisChannelWriter<K, V> defaultWriter;
    private final ClusterEventListener clusterEventListener;
    private final int executionLimit;
    private ClusterConnectionProvider clusterConnectionProvider;
    private boolean closed = false;
    long p20;
    long p21;
    long p22;
    long p23;
    long p24;
    long p25;
    long p26;
    long p30;
    long p31;
    long p32;
    long p33;
    long p34;
    long p35;
    long p36;
    long p37;

    public ClusterDistributionChannelWriter(ClientOptions clientOptions, RedisChannelWriter<K, V> defaultWriter, ClusterEventListener clusterEventListener) {
        this.defaultWriter = defaultWriter;
        this.executionLimit = clientOptions instanceof ClusterClientOptions ? ((ClusterClientOptions)clientOptions).getMaxRedirects() : 5;
        this.clusterEventListener = clusterEventListener;
    }

    @Override
    public <T, C extends RedisCommand<K, V, T>> C write(C command) {
        RedisChannelHandler connection;
        ClusterCommand clusterCommand;
        LettuceAssert.notNull(command, "command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        Object commandToSend = command;
        CommandArgs<K, V> args = command.getArgs();
        if (!(command instanceof ClusterCommand)) {
            C singleCommand = command;
            commandToSend = new ClusterCommand(singleCommand, this, this.executionLimit);
        }
        RedisChannelWriter<K, V> channelWriter = null;
        if (commandToSend instanceof ClusterCommand && !commandToSend.isDone() && ((clusterCommand = (ClusterCommand)commandToSend).isMoved() || clusterCommand.isAsk())) {
            HostAndPort target;
            if (clusterCommand.isMoved()) {
                target = this.getMoveTarget(clusterCommand.getError());
                this.clusterEventListener.onMovedRedirection();
            } else {
                target = this.getAskTarget(clusterCommand.getError());
                this.clusterEventListener.onAskRedirection();
            }
            commandToSend.getOutput().setError((String)null);
            connection = (RedisChannelHandler)((Object)this.clusterConnectionProvider.getConnection(ClusterConnectionProvider.Intent.WRITE, target.getHostText(), target.getPort()));
            channelWriter = connection.getChannelWriter();
            if (clusterCommand.isAsk()) {
                StatefulRedisConnection statefulRedisConnection = (StatefulRedisConnection)((Object)connection);
                statefulRedisConnection.async().asking();
            }
        }
        if (channelWriter == null && args != null && args.getFirstEncodedKey() != null) {
            int hash = SlotHash.getSlot(args.getFirstEncodedKey());
            ClusterConnectionProvider.Intent intent = this.getIntent(command.getType());
            connection = (RedisChannelHandler)((Object)this.clusterConnectionProvider.getConnection(intent, hash));
            channelWriter = connection.getChannelWriter();
        }
        if (channelWriter instanceof ClusterDistributionChannelWriter) {
            ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)channelWriter;
            channelWriter = writer.defaultWriter;
        }
        if (command.getOutput() != null) {
            commandToSend.getOutput().setError((String)null);
        }
        if (channelWriter != null && channelWriter != this && channelWriter != this.defaultWriter) {
            return (C)channelWriter.write(commandToSend);
        }
        this.defaultWriter.write(commandToSend);
        return command;
    }

    private ClusterConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        for (ProtocolKeyword readOnlyCommand : ReadOnlyCommands.READ_ONLY_COMMANDS) {
            if (readOnlyCommand != type) continue;
            return ClusterConnectionProvider.Intent.READ;
        }
        return ClusterConnectionProvider.Intent.WRITE;
    }

    private HostAndPort getMoveTarget(String errorMessage) {
        LettuceAssert.notEmpty(errorMessage, "errorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.MOVED.name()), "errorMessage must start with " + CommandKeyword.MOVED);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "errorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parse(movedMessageParts[2]);
    }

    private HostAndPort getAskTarget(String errorMessage) {
        LettuceAssert.notEmpty(errorMessage, "errorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.ASK.name()), "errorMessage must start with " + CommandKeyword.ASK);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "errorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parse(movedMessageParts[2]);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.defaultWriter != null) {
            this.defaultWriter.close();
        }
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.close();
            this.clusterConnectionProvider = null;
        }
    }

    @Override
    public void setRedisChannelHandler(RedisChannelHandler<K, V> redisChannelHandler) {
        this.defaultWriter.setRedisChannelHandler(redisChannelHandler);
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.getClusterConnectionProvider().setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.getClusterConnectionProvider().flushCommands();
    }

    public ClusterConnectionProvider getClusterConnectionProvider() {
        return this.clusterConnectionProvider;
    }

    @Override
    public void reset() {
        this.defaultWriter.reset();
        this.clusterConnectionProvider.reset();
    }

    public void setClusterConnectionProvider(ClusterConnectionProvider clusterConnectionProvider) {
        this.clusterConnectionProvider = clusterConnectionProvider;
    }

    public void setPartitions(Partitions partitions) {
        this.clusterConnectionProvider.setPartitions(partitions);
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.clusterConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.clusterConnectionProvider.getReadFrom();
    }
}

