/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.lambdaworks.io.netty.buffer.ByteBuf;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandWrapper;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;

class ClusterCommand<K, V, T>
extends CommandWrapper<K, V, T>
implements RedisCommand<K, V, T> {
    private RedisChannelWriter<K, V> retry;
    private int executions;
    private int executionLimit;
    private boolean completed;

    ClusterCommand(RedisCommand<K, V, T> command, RedisChannelWriter<K, V> retry, int executionLimit) {
        super(command);
        this.retry = retry;
        this.executionLimit = executionLimit;
    }

    @Override
    public void complete() {
        ++this.executions;
        if (this.executions < this.executionLimit && (this.isMoved() || this.isAsk())) {
            try {
                this.retry.write(this);
            }
            catch (Exception e) {
                this.completeExceptionally(e);
            }
            return;
        }
        super.complete();
        this.completed = true;
    }

    public boolean isMoved() {
        return this.command.getOutput() != null && this.command.getOutput().getError() != null && this.command.getOutput().getError().startsWith(CommandKeyword.MOVED.name());
    }

    public boolean isAsk() {
        return this.getError() != null && this.getError().startsWith(CommandKeyword.ASK.name());
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean result = this.command.completeExceptionally(ex);
        this.completed = true;
        return result;
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public int getExecutions() {
        return this.executions;
    }

    @Override
    public boolean isDone() {
        return this.isCompleted();
    }

    public String getError() {
        if (this.command.getOutput() != null) {
            return this.command.getOutput().getError();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [command=").append(this.command);
        sb.append(", executions=").append(this.executions);
        sb.append(']');
        return sb.toString();
    }
}

