/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.org.apache.commons.pool2.BasePooledObjectFactory;
import com.lambdaworks.org.apache.commons.pool2.PooledObject;
import com.lambdaworks.org.apache.commons.pool2.PooledObjectFactory;
import com.lambdaworks.org.apache.commons.pool2.impl.DefaultPooledObject;
import com.lambdaworks.org.apache.commons.pool2.impl.GenericObjectPool;
import com.lambdaworks.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.lambdaworks.redis.CloseEvents;
import com.lambdaworks.redis.Connections;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.internal.AbstractInvocationHandler;
import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Set;

public class RedisConnectionPool<T>
implements Closeable {
    private final RedisConnectionProvider<T> redisConnectionProvider;
    private GenericObjectPool<T> objectPool;
    private CloseEvents closeEvents = new CloseEvents();

    public RedisConnectionPool(RedisConnectionProvider<T> redisConnectionProvider, int maxActive, int maxIdle, long maxWait) {
        this.redisConnectionProvider = redisConnectionProvider;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxIdle(maxIdle);
        config.setMaxTotal(maxActive);
        config.setMaxWaitMillis(maxWait);
        config.setTestOnBorrow(true);
        this.objectPool = new GenericObjectPool<T>(this.createFactory(redisConnectionProvider), config);
    }

    private PooledObjectFactory<T> createFactory(final RedisConnectionProvider<T> redisConnectionProvider) {
        return new BasePooledObjectFactory<T>(){

            @Override
            public T create() throws Exception {
                Object connection = redisConnectionProvider.createConnection();
                PooledConnectionInvocationHandler h = new PooledConnectionInvocationHandler(connection, RedisConnectionPool.this);
                Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{redisConnectionProvider.getComponentType()}, h);
                return proxy;
            }

            @Override
            public PooledObject<T> wrap(T obj) {
                return new DefaultPooledObject(obj);
            }

            @Override
            public boolean validateObject(PooledObject<T> p) {
                return Connections.isOpen(p.getObject());
            }

            @Override
            public void destroyObject(PooledObject<T> p) throws Exception {
                Object object = p.getObject();
                if (Proxy.isProxyClass(object.getClass())) {
                    PooledConnectionInvocationHandler invocationHandler = (PooledConnectionInvocationHandler)Proxy.getInvocationHandler(object);
                    object = invocationHandler.getConnection();
                }
                Connections.close(object);
            }
        };
    }

    public T allocateConnection() {
        try {
            return this.objectPool.borrowObject();
        }
        catch (RedisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisException(e.getMessage(), e);
        }
    }

    public void freeConnection(T t) {
        this.objectPool.returnObject(t);
    }

    public int getNumIdle() {
        return this.objectPool.getNumIdle();
    }

    public int getNumActive() {
        return this.objectPool.getNumActive();
    }

    @Override
    public void close() {
        this.objectPool.close();
        this.objectPool = null;
        this.closeEvents.fireEventClosed(this);
        this.closeEvents = null;
    }

    public Class<? extends T> getComponentType() {
        return this.redisConnectionProvider.getComponentType();
    }

    void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    static interface RedisConnectionProvider<T> {
        public T createConnection();

        public Class<? extends T> getComponentType();
    }

    static class PooledConnectionInvocationHandler<T>
    extends AbstractInvocationHandler {
        public static final Set<String> DISABLED_METHODS = Collections.singleton("getStatefulConnection");
        private T connection;
        private final RedisConnectionPool<T> pool;

        public PooledConnectionInvocationHandler(T connection, RedisConnectionPool<T> pool) {
            this.connection = connection;
            this.pool = pool;
        }

        @Override
        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (DISABLED_METHODS.contains(method.getName())) {
                throw new UnsupportedOperationException("Calls to " + method.getName() + " are not supported on pooled connections");
            }
            if (this.connection == null) {
                throw new RedisException("Connection is deallocated and cannot be used anymore.");
            }
            if (method.getName().equals("close")) {
                this.pool.freeConnection(proxy);
                return null;
            }
            try {
                return method.invoke(this.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        public T getConnection() {
            return this.connection;
        }
    }
}

