/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.AbstractRedisClient;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.SslConnectionBuilder;
import com.lambdaworks.redis.StatefulRedisConnectionImpl;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.api.async.RedisAsyncCommands;
import com.lambdaworks.redis.api.sync.RedisCommands;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.internal.LettuceClassUtils;
import com.lambdaworks.redis.internal.LettuceFactories;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnectionImpl;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.SocketAddressResolver;
import com.lambdaworks.redis.sentinel.StatefulRedisSentinelConnectionImpl;
import com.lambdaworks.redis.sentinel.api.StatefulRedisSentinelConnection;
import com.lambdaworks.redis.sentinel.api.async.RedisSentinelAsyncCommands;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public class RedisClient
extends AbstractRedisClient {
    private static final RedisURI EMPTY_URI = new RedisURI();
    private static final boolean POOL_AVAILABLE = LettuceClassUtils.isPresent("com.lambdaworks.org.apache.commons.pool2.impl.GenericObjectPool");
    private final RedisURI redisURI;

    protected RedisClient(ClientResources clientResources, RedisURI redisURI) {
        super(clientResources);
        RedisClient.assertNotNull(redisURI);
        this.redisURI = redisURI;
        this.setDefaultTimeout(redisURI.getTimeout(), redisURI.getUnit());
    }

    @Deprecated
    public RedisClient() {
        this(EMPTY_URI);
    }

    @Deprecated
    public RedisClient(String host) {
        this(host, 6379);
    }

    @Deprecated
    public RedisClient(String host, int port) {
        this(RedisURI.Builder.redis(host, port).build());
    }

    @Deprecated
    public RedisClient(RedisURI redisURI) {
        this(null, redisURI);
    }

    public static RedisClient create() {
        return new RedisClient(null, EMPTY_URI);
    }

    public static RedisClient create(RedisURI redisURI) {
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(null, redisURI);
    }

    public static RedisClient create(String uri) {
        LettuceAssert.notEmpty(uri, "uri must not be empty");
        return new RedisClient(null, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources) {
        RedisClient.assertNotNull(clientResources);
        return new RedisClient(clientResources, EMPTY_URI);
    }

    public static RedisClient create(ClientResources clientResources, String uri) {
        RedisClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty(uri, "uri must not be empty");
        return RedisClient.create(clientResources, RedisURI.create(uri));
    }

    public static RedisClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisClient.assertNotNull(clientResources);
        RedisClient.assertNotNull(redisURI);
        return new RedisClient(clientResources, redisURI);
    }

    public RedisConnectionPool<RedisCommands<String, String>> pool() {
        return this.pool(5, 20);
    }

    public RedisConnectionPool<RedisCommands<String, String>> pool(int maxIdle, int maxActive) {
        return this.pool(this.newStringStringCodec(), maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisCommands<K, V>> pool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkPoolDependency();
        this.checkForRedisURI();
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        long maxWait = this.makeTimeout();
        RedisConnectionPool<RedisCommands<K, V>> pool = new RedisConnectionPool<RedisCommands<K, V>>(new RedisConnectionPool.RedisConnectionProvider<RedisCommands<K, V>>(){

            @Override
            public RedisCommands<K, V> createConnection() {
                return RedisClient.this.connect(codec, RedisClient.this.redisURI).sync();
            }

            @Override
            public Class<? extends RedisCommands<K, V>> getComponentType() {
                return RedisCommands.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(this.closeableResources::remove);
        this.closeableResources.add(pool);
        return pool;
    }

    protected long makeTimeout() {
        return TimeUnit.MILLISECONDS.convert(this.timeout, this.unit);
    }

    public RedisConnectionPool<RedisAsyncCommands<String, String>> asyncPool() {
        return this.asyncPool(5, 20);
    }

    public RedisConnectionPool<RedisAsyncCommands<String, String>> asyncPool(int maxIdle, int maxActive) {
        return this.asyncPool(this.newStringStringCodec(), maxIdle, maxActive);
    }

    public <K, V> RedisConnectionPool<RedisAsyncCommands<K, V>> asyncPool(final RedisCodec<K, V> codec, int maxIdle, int maxActive) {
        this.checkPoolDependency();
        this.checkForRedisURI();
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
        long maxWait = this.makeTimeout();
        RedisConnectionPool<RedisAsyncCommands<K, V>> pool = new RedisConnectionPool<RedisAsyncCommands<K, V>>(new RedisConnectionPool.RedisConnectionProvider<RedisAsyncCommands<K, V>>(){

            @Override
            public RedisAsyncCommands<K, V> createConnection() {
                return RedisClient.this.connectStandalone(codec, RedisClient.this.redisURI, RedisClient.this.defaultTimeout()).async();
            }

            @Override
            public Class<? extends RedisAsyncCommands<K, V>> getComponentType() {
                return RedisAsyncCommands.class;
            }
        }, maxActive, maxIdle, maxWait);
        pool.addListener(this.closeableResources::remove);
        this.closeableResources.add(pool);
        return pool;
    }

    public StatefulRedisConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectStandalone(codec, this.redisURI, this.defaultTimeout());
    }

    public StatefulRedisConnection<String, String> connect(RedisURI redisURI) {
        return this.connectStandalone(this.newStringStringCodec(), redisURI, Timeout.from(redisURI));
    }

    public <K, V> StatefulRedisConnection<K, V> connect(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectStandalone(codec, redisURI, Timeout.from(redisURI));
    }

    @Deprecated
    public RedisAsyncCommands<String, String> connectAsync() {
        return this.connect(this.newStringStringCodec()).async();
    }

    @Deprecated
    public <K, V> RedisAsyncCommands<K, V> connectAsync(RedisCodec<K, V> codec) {
        return this.connectStandalone(codec, this.redisURI, this.defaultTimeout()).async();
    }

    @Deprecated
    public RedisAsyncCommands<String, String> connectAsync(RedisURI redisURI) {
        return this.connectStandalone(this.newStringStringCodec(), redisURI, Timeout.from(redisURI)).async();
    }

    @Deprecated
    public <K, V> RedisAsyncCommands<K, V> connectAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectStandalone(codec, redisURI, Timeout.from(redisURI)).async();
    }

    private <K, V> StatefulRedisConnection<K, V> connectStandalone(RedisCodec<K, V> codec, RedisURI redisURI, Timeout timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        Deque queue = LettuceFactories.newConcurrentQueue();
        CommandHandler handler = new CommandHandler(this.clientOptions, this.clientResources, queue);
        StatefulRedisConnectionImpl connection = this.newStatefulRedisConnection(handler, codec, timeout.timeout, timeout.timeUnit);
        this.connectStateful(handler, connection, redisURI);
        return connection;
    }

    private <K, V> void connectStateful(CommandHandler<K, V> handler, StatefulRedisConnectionImpl<K, V> connection, RedisURI redisURI) {
        ConnectionBuilder connectionBuilder;
        if (redisURI.isSsl()) {
            SslConnectionBuilder sslConnectionBuilder = SslConnectionBuilder.sslConnectionBuilder();
            sslConnectionBuilder.ssl(redisURI);
            connectionBuilder = sslConnectionBuilder;
        } else {
            connectionBuilder = ConnectionBuilder.connectionBuilder();
        }
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        this.connectionBuilder(handler, connection, this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        this.channelType(connectionBuilder, redisURI);
        this.initializeChannel(connectionBuilder);
        if (redisURI.getPassword() != null && redisURI.getPassword().length != 0) {
            connection.async().auth(new String(redisURI.getPassword()));
        }
        if (redisURI.getDatabase() != 0) {
            connection.async().select(redisURI.getDatabase());
        }
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(this.newStringStringCodec(), this.redisURI, this.defaultTimeout());
    }

    public StatefulRedisPubSubConnection<String, String> connectPubSub(RedisURI redisURI) {
        return this.connectPubSub(this.newStringStringCodec(), redisURI, Timeout.from(redisURI));
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectPubSub(codec, this.redisURI, this.defaultTimeout());
    }

    public <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectPubSub(codec, redisURI, Timeout.from(redisURI));
    }

    private <K, V> StatefulRedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec, RedisURI redisURI, Timeout timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        Deque queue = LettuceFactories.newConcurrentQueue();
        PubSubCommandHandler handler = new PubSubCommandHandler(this.clientOptions, this.clientResources, queue, codec);
        StatefulRedisPubSubConnectionImpl connection = this.newStatefulRedisPubSubConnection(handler, codec, timeout.timeout, timeout.timeUnit);
        this.connectStateful(handler, connection, redisURI);
        return connection;
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel() {
        return this.connectSentinel(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectSentinel(codec, this.redisURI, this.defaultTimeout());
    }

    public StatefulRedisSentinelConnection<String, String> connectSentinel(RedisURI redisURI) {
        return this.connectSentinel(this.newStringStringCodec(), redisURI, Timeout.from(redisURI));
    }

    public <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectSentinel(codec, redisURI, Timeout.from(redisURI));
    }

    @Deprecated
    public RedisSentinelAsyncCommands<String, String> connectSentinelAsync() {
        return this.connectSentinel(this.newStringStringCodec(), this.redisURI, this.defaultTimeout()).async();
    }

    @Deprecated
    public <K, V> RedisSentinelAsyncCommands<K, V> connectSentinelAsync(RedisCodec<K, V> codec) {
        this.checkForRedisURI();
        return this.connectSentinel(codec, this.redisURI, this.defaultTimeout()).async();
    }

    @Deprecated
    public RedisSentinelAsyncCommands<String, String> connectSentinelAsync(RedisURI redisURI) {
        return this.connectSentinel(this.newStringStringCodec(), redisURI, Timeout.from(redisURI)).async();
    }

    @Deprecated
    public <K, V> RedisSentinelAsyncCommands<K, V> connectSentinelAsync(RedisCodec<K, V> codec, RedisURI redisURI) {
        return this.connectSentinel(codec, redisURI, Timeout.from(redisURI)).async();
    }

    private <K, V> StatefulRedisSentinelConnection<K, V> connectSentinel(RedisCodec<K, V> codec, RedisURI redisURI, Timeout timeout) {
        RedisClient.assertNotNull(codec);
        this.checkValidRedisURI(redisURI);
        Deque queue = LettuceFactories.newConcurrentQueue();
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(ClientOptions.copyOf(this.getOptions()));
        connectionBuilder.clientResources(this.clientResources);
        CommandHandler commandHandler = new CommandHandler(this.clientOptions, this.clientResources, queue);
        StatefulRedisSentinelConnectionImpl connection = this.newStatefulRedisSentinelConnection(commandHandler, codec, timeout.timeout, timeout.timeUnit);
        logger.debug("Trying to get a Sentinel connection for one of: " + redisURI.getSentinels());
        this.connectionBuilder(commandHandler, connection, this.getSocketAddressSupplier(redisURI), connectionBuilder, redisURI);
        if (redisURI.getSentinels().isEmpty() && (LettuceStrings.isNotEmpty(redisURI.getHost()) || !LettuceStrings.isEmpty(redisURI.getSocket()))) {
            this.channelType(connectionBuilder, redisURI);
            this.initializeChannel(connectionBuilder);
        } else {
            boolean connected = false;
            boolean first = true;
            Exception causingException = null;
            this.validateUrisAreOfSameConnectionType(redisURI.getSentinels());
            for (RedisURI uri : redisURI.getSentinels()) {
                if (first) {
                    this.channelType(connectionBuilder, uri);
                    first = false;
                }
                connectionBuilder.socketAddressSupplier(this.getSocketAddressSupplier(uri));
                if (logger.isDebugEnabled()) {
                    SocketAddress socketAddress = SocketAddressResolver.resolve(redisURI, this.clientResources.dnsResolver());
                    logger.debug("Connecting to Sentinel, address: " + socketAddress);
                }
                try {
                    this.initializeChannel(connectionBuilder);
                    connected = true;
                    break;
                }
                catch (Exception e) {
                    logger.warn("Cannot connect sentinel at " + uri + ": " + e.toString());
                    causingException = e;
                    if (!(e instanceof ConnectException)) continue;
                }
            }
            if (!connected) {
                throw new RedisConnectionException("Cannot connect to a sentinel: " + redisURI.getSentinels(), causingException);
            }
        }
        return connection;
    }

    @Deprecated
    protected <K, V> StatefulRedisPubSubConnectionImpl<K, V> newStatefulRedisPubSubConnection(PubSubCommandHandler<K, V> commandHandler, RedisCodec<K, V> codec) {
        return this.newStatefulRedisPubSubConnection(commandHandler, codec, this.timeout, this.unit);
    }

    protected <K, V> StatefulRedisPubSubConnectionImpl<K, V> newStatefulRedisPubSubConnection(PubSubCommandHandler<K, V> commandHandler, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new StatefulRedisPubSubConnectionImpl<K, V>(commandHandler, codec, timeout, unit);
    }

    @Deprecated
    protected <K, V> StatefulRedisSentinelConnectionImpl<K, V> newStatefulRedisSentinelConnection(CommandHandler<K, V> commandHandler, RedisCodec<K, V> codec) {
        return this.newStatefulRedisSentinelConnection(commandHandler, codec, this.timeout, this.unit);
    }

    protected <K, V> StatefulRedisSentinelConnectionImpl<K, V> newStatefulRedisSentinelConnection(CommandHandler<K, V> commandHandler, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new StatefulRedisSentinelConnectionImpl<K, V>(commandHandler, codec, timeout, unit);
    }

    @Deprecated
    protected <K, V> StatefulRedisConnectionImpl<K, V> newStatefulRedisConnection(CommandHandler<K, V> commandHandler, RedisCodec<K, V> codec) {
        return this.newStatefulRedisConnection(commandHandler, codec, this.timeout, this.unit);
    }

    protected <K, V> StatefulRedisConnectionImpl<K, V> newStatefulRedisConnection(CommandHandler<K, V> commandHandler, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        return new StatefulRedisConnectionImpl<K, V>(commandHandler, codec, timeout, unit);
    }

    private void validateUrisAreOfSameConnectionType(List<RedisURI> redisUris) {
        boolean unixDomainSocket = false;
        boolean inetSocket = false;
        for (RedisURI sentinel : redisUris) {
            if (sentinel.getSocket() != null) {
                unixDomainSocket = true;
            }
            if (sentinel.getHost() == null) continue;
            inetSocket = true;
        }
        if (unixDomainSocket && inetSocket) {
            throw new RedisConnectionException("You cannot mix unix domain socket and IP socket URI's");
        }
    }

    private Supplier<SocketAddress> getSocketAddressSupplier(RedisURI redisURI) {
        return () -> {
            try {
                SocketAddress socketAddress = this.getSocketAddress(redisURI);
                logger.debug("Resolved SocketAddress {} using {}", (Object)socketAddress, (Object)redisURI);
                return socketAddress;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RedisCommandInterruptedException(e);
            }
            catch (ExecutionException | TimeoutException e) {
                throw new RedisException(e);
            }
        };
    }

    public ClientResources getResources() {
        return this.clientResources;
    }

    protected SocketAddress getSocketAddress(RedisURI redisURI) throws InterruptedException, TimeoutException, ExecutionException {
        SocketAddress redisAddress;
        if (redisURI.getSentinelMasterId() != null && !redisURI.getSentinels().isEmpty()) {
            logger.debug("Connecting to Redis using Sentinels {}, MasterId {}", (Object)redisURI.getSentinels(), (Object)redisURI.getSentinelMasterId());
            redisAddress = this.lookupRedis(redisURI);
            if (redisAddress == null) {
                throw new RedisConnectionException("Cannot provide redisAddress using sentinel for masterId " + redisURI.getSentinelMasterId());
            }
        } else {
            redisAddress = SocketAddressResolver.resolve(redisURI, this.clientResources.dnsResolver());
        }
        return redisAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketAddress lookupRedis(RedisURI sentinelUri) throws InterruptedException, TimeoutException, ExecutionException {
        try (RedisSentinelAsyncCommands<String, String> connection = this.connectSentinel(sentinelUri).async();){
            SocketAddress socketAddress = (SocketAddress)connection.getMasterAddrByName(sentinelUri.getSentinelMasterId()).get(this.timeout, this.unit);
            return socketAddress;
        }
    }

    private void checkValidRedisURI(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "A valid RedisURI is needed");
        if (redisURI.getSentinels().isEmpty()) {
            if (LettuceStrings.isEmpty(redisURI.getHost()) && LettuceStrings.isEmpty(redisURI.getSocket())) {
                throw new IllegalArgumentException("RedisURI for Redis Standalone does not contain a host or a socket");
            }
        } else {
            if (LettuceStrings.isEmpty(redisURI.getSentinelMasterId())) {
                throw new IllegalArgumentException("TRedisURI for Redis Sentinel requires a masterId");
            }
            for (RedisURI sentinel : redisURI.getSentinels()) {
                if (!LettuceStrings.isEmpty(sentinel.getHost()) || !LettuceStrings.isEmpty(sentinel.getSocket())) continue;
                throw new IllegalArgumentException("RedisURI for Redis Sentinel does not contain a host or a socket");
            }
        }
    }

    protected Utf8StringCodec newStringStringCodec() {
        return new Utf8StringCodec();
    }

    private static <K, V> void assertNotNull(RedisCodec<K, V> codec) {
        LettuceAssert.notNull(codec, "RedisCodec must not be null");
    }

    private static void assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull(redisURI, "RedisURI must not be null");
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull(clientResources, "ClientResources must not be null");
    }

    private void checkForRedisURI() {
        LettuceAssert.assertState(this.redisURI != EMPTY_URI, "RedisURI is not available. Use RedisClient(Host), RedisClient(Host, Port) or RedisClient(RedisURI) to construct your client.");
        this.checkValidRedisURI(this.redisURI);
    }

    private void checkPoolDependency() {
        LettuceAssert.assertState(POOL_AVAILABLE, "Cannot use connection pooling without the optional Apache commons-pool2 library on the class path");
    }

    @Override
    public void setOptions(ClientOptions clientOptions) {
        super.setOptions(clientOptions);
    }

    private Timeout defaultTimeout() {
        return Timeout.of(this.timeout, this.unit);
    }

    private static class Timeout {
        final long timeout;
        final TimeUnit timeUnit;

        private Timeout(long timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
        }

        private static Timeout of(long timeout, TimeUnit timeUnit) {
            return new Timeout(timeout, timeUnit);
        }

        private static Timeout from(RedisURI redisURI) {
            LettuceAssert.notNull(redisURI, "A valid RedisURI is needed");
            return new Timeout(redisURI.getTimeout(), redisURI.getUnit());
        }
    }
}

