/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.io.netty.bootstrap.Bootstrap;
import com.lambdaworks.io.netty.buffer.PooledByteBufAllocator;
import com.lambdaworks.io.netty.channel.Channel;
import com.lambdaworks.io.netty.channel.ChannelFuture;
import com.lambdaworks.io.netty.channel.ChannelOption;
import com.lambdaworks.io.netty.channel.ChannelPipeline;
import com.lambdaworks.io.netty.channel.EventLoopGroup;
import com.lambdaworks.io.netty.channel.group.ChannelGroup;
import com.lambdaworks.io.netty.channel.group.ChannelGroupFuture;
import com.lambdaworks.io.netty.channel.group.DefaultChannelGroup;
import com.lambdaworks.io.netty.channel.nio.NioEventLoopGroup;
import com.lambdaworks.io.netty.channel.socket.nio.NioSocketChannel;
import com.lambdaworks.io.netty.util.HashedWheelTimer;
import com.lambdaworks.io.netty.util.concurrent.EventExecutorGroup;
import com.lambdaworks.io.netty.util.concurrent.Future;
import com.lambdaworks.io.netty.util.internal.ConcurrentSet;
import com.lambdaworks.io.netty.util.internal.logging.InternalLogger;
import com.lambdaworks.io.netty.util.internal.logging.InternalLoggerFactory;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.ConnectionPoint;
import com.lambdaworks.redis.EpollProvider;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisConnectionStateListener;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.internal.LettuceAssert;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.DefaultClientResources;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public abstract class AbstractRedisClient {
    protected static final PooledByteBufAllocator BUF_ALLOCATOR = PooledByteBufAllocator.DEFAULT;
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisClient.class);
    @Deprecated
    protected EventLoopGroup eventLoopGroup;
    protected EventExecutorGroup genericWorkerPool;
    protected final Map<Class<? extends EventLoopGroup>, EventLoopGroup> eventLoopGroups = new ConcurrentHashMap<Class<? extends EventLoopGroup>, EventLoopGroup>();
    protected final HashedWheelTimer timer;
    protected final ChannelGroup channels;
    protected final ClientResources clientResources;
    protected long timeout = 60L;
    protected TimeUnit unit;
    protected ConnectionEvents connectionEvents = new ConnectionEvents();
    protected Set<Closeable> closeableResources = new ConcurrentSet<Closeable>();
    protected volatile ClientOptions clientOptions = ClientOptions.builder().build();
    private final boolean sharedResources;
    private final AtomicBoolean shutdown = new AtomicBoolean();

    @Deprecated
    protected AbstractRedisClient() {
        this(null);
    }

    protected AbstractRedisClient(ClientResources clientResources) {
        if (clientResources == null) {
            this.sharedResources = false;
            this.clientResources = DefaultClientResources.create();
        } else {
            this.sharedResources = true;
            this.clientResources = clientResources;
        }
        this.unit = TimeUnit.SECONDS;
        this.genericWorkerPool = this.clientResources.eventExecutorGroup();
        this.channels = new DefaultChannelGroup(this.genericWorkerPool.next());
        this.timer = new HashedWheelTimer();
    }

    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> T connectAsyncImpl(CommandHandler<K, V> handler, T connection, Supplier<SocketAddress> socketAddressSupplier) {
        ConnectionBuilder connectionBuilder = ConnectionBuilder.connectionBuilder();
        connectionBuilder.clientOptions(this.clientOptions);
        connectionBuilder.clientResources(this.clientResources);
        this.connectionBuilder(handler, connection, socketAddressSupplier, connectionBuilder, null);
        this.channelType(connectionBuilder, null);
        return this.initializeChannel(connectionBuilder);
    }

    protected void connectionBuilder(CommandHandler<?, ?> handler, RedisChannelHandler<?, ?> connection, Supplier<SocketAddress> socketAddressSupplier, ConnectionBuilder connectionBuilder, RedisURI redisURI) {
        Bootstrap redisBootstrap = new Bootstrap();
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, 32768);
        redisBootstrap.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, 8192);
        redisBootstrap.option(ChannelOption.ALLOCATOR, BUF_ALLOCATOR);
        if (redisURI == null) {
            redisBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)this.unit.toMillis(this.timeout));
            connectionBuilder.timeout(this.timeout, this.unit);
        } else {
            redisBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)redisURI.getUnit().toMillis(redisURI.getTimeout()));
            connectionBuilder.timeout(redisURI.getTimeout(), redisURI.getUnit());
            connectionBuilder.password(redisURI.getPassword());
        }
        connectionBuilder.bootstrap(redisBootstrap);
        connectionBuilder.channelGroup(this.channels).connectionEvents(this.connectionEvents).timer(this.timer);
        connectionBuilder.commandHandler(handler).socketAddressSupplier(socketAddressSupplier).connection(connection);
        connectionBuilder.workerPool(this.genericWorkerPool);
    }

    protected void channelType(ConnectionBuilder connectionBuilder, ConnectionPoint connectionPoint) {
        connectionBuilder.bootstrap().group(this.getEventLoopGroup(connectionPoint));
        if (connectionPoint != null && connectionPoint.getSocket() != null) {
            this.checkForEpollLibrary();
            connectionBuilder.bootstrap().channel(EpollProvider.epollDomainSocketChannelClass);
        } else {
            connectionBuilder.bootstrap().channel(NioSocketChannel.class);
        }
    }

    private synchronized EventLoopGroup getEventLoopGroup(ConnectionPoint connectionPoint) {
        if (!(connectionPoint != null && connectionPoint.getSocket() != null || this.eventLoopGroups.containsKey(NioEventLoopGroup.class))) {
            if (this.eventLoopGroup == null) {
                this.eventLoopGroup = this.clientResources.eventLoopGroupProvider().allocate(NioEventLoopGroup.class);
            }
            this.eventLoopGroups.put(NioEventLoopGroup.class, this.eventLoopGroup);
        }
        if (connectionPoint != null && connectionPoint.getSocket() != null) {
            this.checkForEpollLibrary();
            if (!this.eventLoopGroups.containsKey(EpollProvider.epollEventLoopGroupClass)) {
                EventLoopGroup epl = this.clientResources.eventLoopGroupProvider().allocate(EpollProvider.epollEventLoopGroupClass);
                this.eventLoopGroups.put(EpollProvider.epollEventLoopGroupClass, epl);
            }
        }
        if (connectionPoint == null || connectionPoint.getSocket() == null) {
            return this.eventLoopGroups.get(NioEventLoopGroup.class);
        }
        if (connectionPoint != null && connectionPoint.getSocket() != null) {
            this.checkForEpollLibrary();
            return this.eventLoopGroups.get(EpollProvider.epollEventLoopGroupClass);
        }
        throw new IllegalStateException("This should not have happened in a binary decision. Please file a bug.");
    }

    private void checkForEpollLibrary() {
        EpollProvider.checkForEpollLibrary();
    }

    protected <K, V, T extends RedisChannelHandler<K, V>> T initializeChannel(ConnectionBuilder connectionBuilder) {
        RedisChannelHandler<?, ?> connection = connectionBuilder.connection();
        SocketAddress redisAddress = connectionBuilder.socketAddress();
        try {
            logger.debug("Connecting to Redis at {}", (Object)redisAddress);
            Bootstrap redisBootstrap = connectionBuilder.bootstrap();
            RedisChannelInitializer initializer = connectionBuilder.build();
            redisBootstrap.handler(initializer);
            ChannelFuture connectFuture = redisBootstrap.connect(redisAddress);
            connectFuture.await();
            if (!connectFuture.isSuccess()) {
                if (connectFuture.cause() instanceof Exception) {
                    throw (Exception)connectFuture.cause();
                }
                connectFuture.get();
            }
            try {
                initializer.channelInitialized().get(connectionBuilder.getTimeout(), connectionBuilder.getTimeUnit());
            }
            catch (TimeoutException e) {
                throw new RedisConnectionException("Could not initialize channel within " + connectionBuilder.getTimeout() + " " + (Object)((Object)connectionBuilder.getTimeUnit()), e);
            }
            connection.registerCloseables(this.closeableResources, connection, connectionBuilder.commandHandler());
            return (T)connection;
        }
        catch (RedisException e) {
            connectionBuilder.commandHandler().initialState();
            throw e;
        }
        catch (Exception e) {
            connectionBuilder.commandHandler().initialState();
            throw new RedisConnectionException("Unable to connect to " + redisAddress, e);
        }
    }

    public void shutdown() {
        this.shutdown(2L, 15L, TimeUnit.SECONDS);
    }

    public void shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        if (this.shutdown.compareAndSet(false, true)) {
            this.timer.stop();
            while (!this.closeableResources.isEmpty()) {
                Closeable closeableResource = this.closeableResources.iterator().next();
                try {
                    closeableResource.close();
                }
                catch (Exception e) {
                    logger.debug("Exception on Close: " + e.getMessage(), e);
                }
                this.closeableResources.remove(closeableResource);
            }
            ArrayList<Future<Boolean>> closeFutures = new ArrayList<Future<Boolean>>();
            for (Channel c : this.channels) {
                PubSubCommandHandler psCommandHandler;
                ChannelPipeline channelPipeline = c.pipeline();
                CommandHandler commandHandler = channelPipeline.get(CommandHandler.class);
                if (commandHandler != null && !commandHandler.isClosed()) {
                    commandHandler.close();
                }
                if ((psCommandHandler = channelPipeline.get(PubSubCommandHandler.class)) == null || psCommandHandler.isClosed()) continue;
                psCommandHandler.close();
            }
            ChannelGroupFuture closeFuture = this.channels.close();
            closeFutures.add(closeFuture);
            if (!this.sharedResources) {
                this.clientResources.shutdown(quietPeriod, timeout, timeUnit);
            } else {
                for (EventLoopGroup eventLoopGroup : this.eventLoopGroups.values()) {
                    Future<Boolean> groupCloseFuture = this.clientResources.eventLoopGroupProvider().release(eventLoopGroup, quietPeriod, timeout, timeUnit);
                    closeFutures.add(groupCloseFuture);
                }
            }
            for (Future future : closeFutures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RedisException(e);
                }
            }
        }
    }

    protected int getResourceCount() {
        return this.closeableResources.size();
    }

    protected int getChannelCount() {
        return this.channels.size();
    }

    public void addListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull(listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.addListener(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        LettuceAssert.notNull(listener, "RedisConnectionStateListener must not be null");
        this.connectionEvents.removeListener(listener);
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    protected void setOptions(ClientOptions clientOptions) {
        LettuceAssert.notNull(clientOptions, "clientOptions must not be null");
        this.clientOptions = clientOptions;
    }
}

