/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.support;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.AbstractInvocationHandler;
import com.lambdaworks.redis.RedisConnectionPool;
import com.lambdaworks.redis.RedisException;
import java.lang.reflect.Method;

public class TransparentPoolingInvocationHandler<T>
extends AbstractInvocationHandler {
    private RedisConnectionPool<T> pool;
    private LoadingCache<Method, Method> methodCache;

    public TransparentPoolingInvocationHandler(final RedisConnectionPool<T> pool) {
        this.pool = pool;
        this.methodCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Method, Method>(){

            public Method load(Method key) throws Exception {
                return pool.getComponentType().getMethod(key.getName(), key.getParameterTypes());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        Method targetMethod = (Method)this.methodCache.get((Object)method);
        if (this.pool == null) {
            throw new RedisException("Connection pool is closed");
        }
        if (method.getName().equals("close")) {
            this.pool.close();
            this.pool = null;
            return null;
        }
        T connection = this.pool.allocateConnection();
        try {
            Object object = targetMethod.invoke(connection, args);
            return object;
        }
        finally {
            this.pool.freeConnection(connection);
        }
    }

    public RedisConnectionPool<T> getPool() {
        return this.pool;
    }
}

