/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.lambdaworks.redis.RedisAsyncCommandsImpl;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import com.lambdaworks.redis.pubsub.StatefulRedisPubSubConnection;
import com.lambdaworks.redis.pubsub.api.async.RedisPubSubAsyncCommands;

public class RedisPubSubAsyncCommandsImpl<K, V>
extends RedisAsyncCommandsImpl<K, V>
implements RedisPubSubConnection<K, V>,
RedisPubSubAsyncCommands<K, V> {
    public RedisPubSubAsyncCommandsImpl(StatefulRedisPubSubConnection<K, V> connection, RedisCodec<K, V> codec) {
        super(connection, codec);
        this.connection = connection;
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.getStatefulConnection().addListener(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.getStatefulConnection().removeListener(listener);
    }

    @Override
    public RedisFuture<Void> psubscribe(K ... patterns) {
        return this.dispatch(CommandType.PSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns));
    }

    @Override
    public RedisFuture<Void> punsubscribe(K ... patterns) {
        return this.dispatch(CommandType.PUNSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns));
    }

    @Override
    public RedisFuture<Void> subscribe(K ... channels) {
        return this.dispatch(CommandType.SUBSCRIBE, new PubSubOutput(this.codec), this.args(channels));
    }

    @Override
    public RedisFuture<Void> unsubscribe(K ... channels) {
        return this.dispatch(CommandType.UNSUBSCRIBE, new PubSubOutput(this.codec), this.args(channels));
    }

    private CommandArgs<K, V> args(K ... keys) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKeys(keys);
        return args;
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getStatefulConnection() {
        return (StatefulRedisPubSubConnection)super.getStatefulConnection();
    }
}

