/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.partitions;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

public class RedisClusterNode
implements Serializable,
RedisNodeDescription {
    private RedisURI uri;
    private String nodeId;
    private boolean connected;
    private String slaveOf;
    private long pingSentTimestamp;
    private long pongReceivedTimestamp;
    private long configEpoch;
    private List<Integer> slots;
    private Set<NodeFlag> flags;

    public RedisClusterNode() {
    }

    public RedisClusterNode(RedisURI uri, String nodeId, boolean connected, String slaveOf, long pingSentTimestamp, long pongReceivedTimestamp, long configEpoch, List<Integer> slots, Set<NodeFlag> flags) {
        this.uri = uri;
        this.nodeId = nodeId;
        this.connected = connected;
        this.slaveOf = slaveOf;
        this.pingSentTimestamp = pingSentTimestamp;
        this.pongReceivedTimestamp = pongReceivedTimestamp;
        this.configEpoch = configEpoch;
        this.slots = slots;
        this.flags = flags;
    }

    public static RedisClusterNode of(String nodeId) {
        RedisClusterNode redisClusterNode = new RedisClusterNode();
        redisClusterNode.setNodeId(nodeId);
        return redisClusterNode;
    }

    @Override
    public RedisURI getUri() {
        return this.uri;
    }

    public void setUri(RedisURI uri) {
        Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri must not be null");
        this.uri = uri;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        Preconditions.checkArgument((nodeId != null ? 1 : 0) != 0, (Object)"nodeId must not be null");
        this.nodeId = nodeId;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String getSlaveOf() {
        return this.slaveOf;
    }

    public void setSlaveOf(String slaveOf) {
        this.slaveOf = slaveOf;
    }

    public long getPingSentTimestamp() {
        return this.pingSentTimestamp;
    }

    public void setPingSentTimestamp(long pingSentTimestamp) {
        this.pingSentTimestamp = pingSentTimestamp;
    }

    public long getPongReceivedTimestamp() {
        return this.pongReceivedTimestamp;
    }

    public void setPongReceivedTimestamp(long pongReceivedTimestamp) {
        this.pongReceivedTimestamp = pongReceivedTimestamp;
    }

    public long getConfigEpoch() {
        return this.configEpoch;
    }

    public void setConfigEpoch(long configEpoch) {
        this.configEpoch = configEpoch;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Integer> slots) {
        Preconditions.checkArgument((slots != null ? 1 : 0) != 0, (Object)"slots must not be null");
        this.slots = slots;
    }

    public Set<NodeFlag> getFlags() {
        return this.flags;
    }

    public void setFlags(Set<NodeFlag> flags) {
        this.flags = flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisClusterNode)) {
            return false;
        }
        RedisClusterNode that = (RedisClusterNode)o;
        return !(this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null);
    }

    public int hashCode() {
        int result = 31 * (this.nodeId != null ? this.nodeId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [uri=").append(this.uri);
        sb.append(", nodeId='").append(this.nodeId).append('\'');
        sb.append(", connected=").append(this.connected);
        sb.append(", slaveOf='").append(this.slaveOf).append('\'');
        sb.append(", pingSentTimestamp=").append(this.pingSentTimestamp);
        sb.append(", pongReceivedTimestamp=").append(this.pongReceivedTimestamp);
        sb.append(", configEpoch=").append(this.configEpoch);
        sb.append(", flags=").append(this.flags);
        if (this.slots != null) {
            sb.append(", slot count=").append(this.slots.size());
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean is(NodeFlag nodeFlag) {
        return this.getFlags().contains((Object)nodeFlag);
    }

    public boolean hasSlot(int slot) {
        return this.getSlots().contains(slot);
    }

    @Override
    public RedisInstance.Role getRole() {
        return this.is(NodeFlag.MASTER) ? RedisInstance.Role.MASTER : RedisInstance.Role.SLAVE;
    }

    public static enum NodeFlag {
        NOFLAGS,
        MYSELF,
        SLAVE,
        MASTER,
        EVENTUAL_FAIL,
        FAIL,
        HANDSHAKE,
        NOADDR;

    }
}

