/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.partitions;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Partitions
extends AbstractCollection<RedisClusterNode>
implements Collection<RedisClusterNode> {
    private List<RedisClusterNode> partitions = Lists.newArrayList();
    private RedisClusterNode[] slotCache;

    public RedisClusterNode getPartitionBySlot(int slot) {
        return this.slotCache[slot];
    }

    public RedisClusterNode getPartitionByNodeId(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition;
        }
        return null;
    }

    public synchronized void updateCache() {
        if (this.slotCache == null) {
            this.slotCache = new RedisClusterNode[16384];
        } else {
            Arrays.fill(this.slotCache, null);
        }
        for (RedisClusterNode partition : this.partitions) {
            for (Integer integer : partition.getSlots()) {
                this.slotCache[integer.intValue()] = partition;
            }
        }
    }

    @Override
    public Iterator<RedisClusterNode> iterator() {
        return this.partitions.iterator();
    }

    public List<RedisClusterNode> getPartitions() {
        return this.partitions;
    }

    public void addPartition(RedisClusterNode partition) {
        this.slotCache = null;
        this.partitions.add(partition);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" ").append(this.partitions);
        return sb.toString();
    }

    @Override
    public int size() {
        return this.getPartitions().size();
    }

    public RedisClusterNode getPartition(int index) {
        return this.getPartitions().get(index);
    }

    public void reload(List<RedisClusterNode> partitions) {
        this.partitions.clear();
        this.partitions.addAll(partitions);
        this.updateCache();
    }
}

