/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.api.sync;

import com.lambdaworks.redis.cluster.RedisAdvancedClusterConnection;
import com.lambdaworks.redis.cluster.api.StatefulRedisClusterConnection;
import com.lambdaworks.redis.cluster.api.sync.NodeSelection;
import com.lambdaworks.redis.cluster.api.sync.RedisClusterCommands;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.output.KeyStreamingChannel;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public interface RedisAdvancedClusterCommands<K, V>
extends RedisClusterCommands<K, V>,
RedisAdvancedClusterConnection<K, V> {
    @Override
    public RedisClusterCommands<K, V> getConnection(String var1);

    @Override
    public RedisClusterCommands<K, V> getConnection(String var1, int var2);

    @Override
    public StatefulRedisClusterConnection<K, V> getStatefulConnection();

    default public NodeSelection<K, V> masters() {
        return this.nodes(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.MASTER));
    }

    default public NodeSelection<K, V> slaves() {
        return this.readonly(redisClusterNode -> redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public NodeSelection<K, V> slaves(Predicate<RedisClusterNode> predicate) {
        return this.readonly(redisClusterNode -> predicate.test((RedisClusterNode)redisClusterNode) && redisClusterNode.is(RedisClusterNode.NodeFlag.SLAVE));
    }

    default public NodeSelection<K, V> all() {
        return this.nodes(redisClusterNode -> true);
    }

    public NodeSelection<K, V> readonly(Predicate<RedisClusterNode> var1);

    public NodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1);

    public NodeSelection<K, V> nodes(Predicate<RedisClusterNode> var1, boolean var2);

    @Override
    public Long del(K ... var1);

    @Override
    public List<V> mget(K ... var1);

    @Override
    public String mset(Map<K, V> var1);

    @Override
    public Boolean msetnx(Map<K, V> var1);

    @Override
    public String clientSetname(K var1);

    @Override
    public String flushall();

    @Override
    public String flushdb();

    @Override
    public Long dbsize();

    @Override
    public List<K> keys(K var1);

    @Override
    public Long keys(KeyStreamingChannel<K> var1, K var2);

    @Override
    public V randomkey();

    @Override
    public String scriptFlush();

    @Override
    public String scriptKill();

    @Override
    public void shutdown(boolean var1);
}

