/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.pubsub;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.pubsub.PubSubOutput;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import com.lambdaworks.redis.pubsub.VoidFuture;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RedisPubSubConnectionImpl<K, V>
extends RedisAsyncConnectionImpl<K, V>
implements RedisPubSubConnection<K, V> {
    protected final List<RedisPubSubListener<K, V>> listeners = Lists.newCopyOnWriteArrayList();
    protected final Set<K> channels = Sets.newConcurrentHashSet();
    protected final Set<K> patterns = Sets.newConcurrentHashSet();

    public RedisPubSubConnectionImpl(RedisChannelWriter<K, V> writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, codec, timeout, unit);
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public RedisFuture<Void> psubscribe(K ... patterns) {
        return new VoidFuture(this.dispatch(CommandType.PSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns)));
    }

    @Override
    public RedisFuture<Void> punsubscribe(K ... patterns) {
        return new VoidFuture(this.dispatch(CommandType.PUNSUBSCRIBE, new PubSubOutput(this.codec), this.args(patterns)));
    }

    @Override
    public RedisFuture<Void> subscribe(K ... channels) {
        return new VoidFuture(this.dispatch(CommandType.SUBSCRIBE, new PubSubOutput(this.codec), this.args(channels)));
    }

    @Override
    public RedisFuture<Void> unsubscribe(K ... channels) {
        return new VoidFuture(this.dispatch(CommandType.UNSUBSCRIBE, new PubSubOutput(this.codec), this.args(channels)));
    }

    @Override
    public void activated() {
        super.activated();
        this.resubscribe();
    }

    protected List<RedisFuture<Void>> resubscribe() {
        ArrayList result = Lists.newArrayList();
        if (!this.channels.isEmpty()) {
            result.add(this.subscribe(this.toArray(this.channels)));
        }
        if (!this.patterns.isEmpty()) {
            result.add(this.psubscribe(this.toArray(this.patterns)));
        }
        return result;
    }

    @Override
    public void channelRead(Object msg) {
        PubSubOutput output = (PubSubOutput)msg;
        if (output.type() == null || output.pattern() == null && output.channel() == null && output.get() == null) {
            return;
        }
        this.updateInternalState(output);
        this.notifyListeners(output);
    }

    private void updateInternalState(PubSubOutput<K, V, V> output) {
        switch (output.type()) {
            case psubscribe: {
                this.patterns.add(output.pattern());
                break;
            }
            case punsubscribe: {
                this.patterns.remove(output.pattern());
                break;
            }
            case subscribe: {
                this.channels.add(output.channel());
                break;
            }
            case unsubscribe: {
                this.channels.remove(output.channel());
                break;
            }
        }
    }

    private void notifyListeners(PubSubOutput<K, V, V> output) {
        block8: for (RedisPubSubListener redisPubSubListener : this.listeners) {
            switch (output.type()) {
                case message: {
                    redisPubSubListener.message(output.channel(), output.get());
                    continue block8;
                }
                case pmessage: {
                    redisPubSubListener.message(output.pattern(), output.channel(), output.get());
                    continue block8;
                }
                case psubscribe: {
                    redisPubSubListener.psubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case punsubscribe: {
                    redisPubSubListener.punsubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case subscribe: {
                    redisPubSubListener.subscribed(output.channel(), output.count());
                    continue block8;
                }
                case unsubscribe: {
                    redisPubSubListener.unsubscribed(output.channel(), output.count());
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Operation " + (Object)((Object)output.type()) + " not supported");
        }
    }

    private CommandArgs<K, V> args(K ... keys) {
        CommandArgs args = new CommandArgs(this.codec);
        args.addKeys(keys);
        return args;
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }
}

