/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;

public class RedisStateMachine<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisStateMachine.class);
    private static final ByteBuffer QUEUED = LettuceCharsets.buffer("QUEUED");
    private final Deque<State> stack = new LinkedList<State>();

    public boolean decode(ByteBuf buffer, CommandOutput<K, V, ?> output) {
        return this.decode(buffer, null, output);
    }

    public boolean decode(ByteBuf buffer, RedisCommand<K, V, ?> command, CommandOutput<K, V, ?> output) {
        if (logger.isDebugEnabled()) {
            logger.debug("Decode " + command);
        }
        if (this.stack.isEmpty()) {
            this.stack.add(new State());
        }
        if (output == null) {
            return this.stack.isEmpty();
        }
        block8: while (!this.stack.isEmpty()) {
            State state = this.stack.peek();
            if (state.type == null) {
                if (!buffer.isReadable()) break;
                state.type = this.readReplyType(buffer);
                buffer.markReaderIndex();
            }
            switch (state.type) {
                case SINGLE: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) break block8;
                    if (QUEUED.equals(bytes)) break;
                    output.set(bytes);
                    break;
                }
                case ERROR: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) break block8;
                    output.setError(bytes);
                    break;
                }
                case INTEGER: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) break block8;
                    output.set(this.readLong(buffer, buffer.readerIndex(), end));
                    break;
                }
                case BULK: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) break block8;
                    int length = (int)this.readLong(buffer, buffer.readerIndex(), end);
                    if (length == -1) {
                        output.set(null);
                        break;
                    }
                    state.type = State.Type.BYTES;
                    state.count = length + 2;
                    buffer.markReaderIndex();
                    continue block8;
                }
                case MULTI: {
                    int length;
                    int end;
                    if (state.count == -1) {
                        end = this.findLineEnd(buffer);
                        if (end == -1) break block8;
                        state.count = length = (int)this.readLong(buffer, buffer.readerIndex(), end);
                        buffer.markReaderIndex();
                        output.multi(state.count);
                    }
                    if (state.count <= 0) break;
                    --state.count;
                    this.stack.addFirst(new State());
                    continue block8;
                }
                case BYTES: {
                    ByteBuffer bytes = this.readBytes(buffer, state.count);
                    if (bytes == null) break block8;
                    output.set(bytes);
                    break;
                }
                default: {
                    throw new IllegalStateException("State " + (Object)((Object)state.type) + " not supported");
                }
            }
            buffer.markReaderIndex();
            this.stack.remove();
            output.complete(this.stack.size());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Decoded " + command + ", empty stack: " + this.stack.isEmpty());
        }
        return this.stack.isEmpty();
    }

    private int findLineEnd(ByteBuf buffer) {
        int start = buffer.readerIndex();
        int index = buffer.indexOf(start, buffer.writerIndex(), (byte)10);
        return index > 0 && buffer.getByte(index - 1) == 13 ? index : -1;
    }

    private State.Type readReplyType(ByteBuf buffer) {
        byte b = buffer.readByte();
        switch (b) {
            case 43: {
                return State.Type.SINGLE;
            }
            case 45: {
                return State.Type.ERROR;
            }
            case 58: {
                return State.Type.INTEGER;
            }
            case 36: {
                return State.Type.BULK;
            }
            case 42: {
                return State.Type.MULTI;
            }
        }
        throw new RedisException("Invalid first byte: " + Byte.toString(b));
    }

    private long readLong(ByteBuf buffer, int start, int end) {
        int offset;
        long value = 0L;
        boolean negative = buffer.getByte(start) == 45;
        int n = offset = negative ? start + 1 : start;
        while (offset < end - 1) {
            int digit = buffer.getByte(offset++) - 48;
            value = value * 10L - (long)digit;
        }
        if (!negative) {
            value = -value;
        }
        buffer.readerIndex(end + 1);
        return value;
    }

    private ByteBuffer readLine(ByteBuf buffer) {
        ByteBuffer bytes = null;
        int end = this.findLineEnd(buffer);
        if (end > -1) {
            int start = buffer.readerIndex();
            bytes = buffer.nioBuffer(start, end - start - 1);
            buffer.readerIndex(end + 1);
            buffer.markReaderIndex();
        }
        return bytes;
    }

    private ByteBuffer readBytes(ByteBuf buffer, int count) {
        ByteBuffer bytes = null;
        if (buffer.readableBytes() >= count) {
            bytes = buffer.nioBuffer(buffer.readerIndex(), count - 2);
            buffer.readerIndex(buffer.readerIndex() + count);
        }
        return bytes;
    }

    public void reset() {
        this.stack.clear();
    }

    static class State {
        Type type = null;
        int count = -1;

        State() {
        }

        static enum Type {
            SINGLE,
            ERROR,
            INTEGER,
            BULK,
            MULTI,
            BYTES;

        }
    }
}

