/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.google.common.base.Supplier;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.protocol.CommandHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.internal.logging.InternalLogLevel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter
implements TimerTask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ConnectionWatchdog.class);
    public static final long LOGGING_QUIET_TIME_MS = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    public static final int RETRY_TIMEOUT_MAX = 14;
    private ClientOptions clientOptions;
    private Bootstrap bootstrap;
    private Channel channel;
    private Timer timer;
    private boolean listenOnChannelInactive;
    private boolean reconnectSuspended;
    private int attempts;
    private SocketAddress remoteAddress;
    private Supplier<SocketAddress> socketAddressSupplier;
    private long lastReconnectionLogging = -1L;

    public ConnectionWatchdog(ClientOptions clientOptions, Bootstrap bootstrap, Timer timer) {
        this(clientOptions, bootstrap, timer, null);
    }

    public ConnectionWatchdog(ClientOptions clientOptions, Bootstrap bootstrap, Timer timer, Supplier<SocketAddress> socketAddressSupplier) {
        this.clientOptions = clientOptions;
        this.bootstrap = bootstrap;
        this.timer = timer;
        this.socketAddressSupplier = socketAddressSupplier;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        logger.debug("userEventTriggered(" + ctx + ", " + evt + ")");
        if (evt instanceof ConnectionEvents.PrepareClose) {
            ConnectionEvents.PrepareClose prepareClose = (ConnectionEvents.PrepareClose)evt;
            this.setListenOnChannelInactive(false);
            prepareClose.getPrepareCloseFuture().set((Object)true);
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("channelActive(" + ctx + ")");
        this.channel = ctx.channel();
        this.attempts = 0;
        this.remoteAddress = this.channel.remoteAddress();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.debug("channelInactive(" + ctx + ")");
        this.channel = null;
        if (this.listenOnChannelInactive && !this.reconnectSuspended) {
            this.scheduleReconnect();
        }
        super.channelInactive(ctx);
    }

    public void scheduleReconnect() {
        logger.debug("scheduleReconnect()");
        if (this.channel == null || !this.channel.isActive()) {
            if (this.attempts < 14) {
                ++this.attempts;
            }
            int timeout = 2 << this.attempts;
            this.timer.newTimeout((TimerTask)this, (long)timeout, TimeUnit.MILLISECONDS);
        } else {
            logger.debug("Skipping scheduleReconnect() because I have an active channel");
        }
    }

    public void run(Timeout timeout) throws Exception {
        boolean shouldLog = this.shouldLog();
        InternalLogLevel infoLevel = InternalLogLevel.INFO;
        InternalLogLevel warnLevel = InternalLogLevel.WARN;
        if (shouldLog) {
            this.lastReconnectionLogging = System.currentTimeMillis();
        } else {
            warnLevel = InternalLogLevel.DEBUG;
            infoLevel = InternalLogLevel.DEBUG;
        }
        try {
            this.reconnect(infoLevel, warnLevel);
        }
        catch (Exception e) {
            logger.log(warnLevel, "Cannot connect: " + e.toString());
            this.scheduleReconnect();
        }
    }

    private void reconnect(InternalLogLevel infoLevel, InternalLogLevel warnLevel) throws InterruptedException {
        logger.log(infoLevel, "Reconnecting, last destination was " + this.remoteAddress);
        if (this.socketAddressSupplier != null) {
            try {
                this.remoteAddress = (SocketAddress)this.socketAddressSupplier.get();
            }
            catch (RuntimeException e) {
                logger.log(warnLevel, "Cannot retrieve the current address from socketAddressSupplier: " + e.toString());
            }
        }
        ChannelFuture connect = this.bootstrap.connect(this.remoteAddress);
        connect.sync().await();
        RedisChannelInitializer channelInitializer = (RedisChannelInitializer)connect.channel().pipeline().get(RedisChannelInitializer.class);
        CommandHandler commandHandler = (CommandHandler)connect.channel().pipeline().get(CommandHandler.class);
        try {
            channelInitializer.channelInitialized().get();
            logger.log(infoLevel, "Reconnected to " + this.remoteAddress);
        }
        catch (Exception e) {
            if (this.clientOptions.isCancelCommandsOnReconnectFailure()) {
                commandHandler.reset();
            }
            if (this.clientOptions.isSuspendReconnectOnProtocolFailure()) {
                logger.error("Cannot initialize channel. Disabling autoReconnect", (Throwable)e);
                this.setReconnectSuspended(true);
            }
            logger.error("Cannot initialize channel.", (Throwable)e);
        }
    }

    private boolean shouldLog() {
        long quietUntil = this.lastReconnectionLogging + LOGGING_QUIET_TIME_MS;
        return quietUntil <= System.currentTimeMillis();
    }

    @Deprecated
    public void setReconnect(boolean reconnect) {
        this.setListenOnChannelInactive(reconnect);
    }

    public void setListenOnChannelInactive(boolean listenOnChannelInactive) {
        this.listenOnChannelInactive = listenOnChannelInactive;
    }

    public boolean isListenOnChannelInactive() {
        return this.listenOnChannelInactive;
    }

    public boolean isReconnectSuspended() {
        return this.reconnectSuspended;
    }

    public void setReconnectSuspended(boolean reconnectSuspended) {
        this.reconnectSuspended = reconnectSuspended;
    }
}

