/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.google.common.util.concurrent.AbstractFuture;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.LettuceCharsets;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Command<K, V, T>
extends AbstractFuture<T>
implements RedisCommand<K, V, T> {
    private static final byte[] CRLF = "\r\n".getBytes(LettuceCharsets.ASCII);
    protected CommandArgs<K, V> args;
    protected CommandOutput<K, V, T> output;
    protected CountDownLatch latch;
    private final ProtocolKeyword type;
    private boolean multi;
    private Throwable exception;
    private boolean cancelled = false;

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        this(type, output, args, false);
    }

    public Command(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args, boolean multi) {
        this.type = type;
        this.output = output;
        this.args = args;
        this.setMulti(multi);
    }

    public void setMulti(boolean multi) {
        this.latch = new CountDownLatch(multi ? 2 : 1);
        this.multi = multi;
    }

    public boolean isMulti() {
        return this.multi;
    }

    protected void interruptTask() {
        this.cancelled = true;
        if (this.latch.getCount() == 1L) {
            this.latch.countDown();
        }
    }

    public boolean isCancelled() {
        return this.latch.getCount() == 0L && this.cancelled;
    }

    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    public T get() throws ExecutionException {
        try {
            this.latch.await();
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.output.get();
        }
        catch (InterruptedException e) {
            throw new RedisCommandInterruptedException(e);
        }
    }

    public T get(long timeout, TimeUnit unit) throws TimeoutException, ExecutionException {
        try {
            if (!this.latch.await(timeout, unit)) {
                throw new TimeoutException("Command timed out");
            }
        }
        catch (InterruptedException e) {
            throw new RedisCommandInterruptedException(e);
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.output.get();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        try {
            return this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RedisCommandInterruptedException(e);
        }
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.output;
    }

    @Override
    public void complete() {
        this.latch.countDown();
        if (this.latch.getCount() == 0L) {
            if (this.output == null) {
                this.set(null);
            } else {
                this.set(this.output.get());
            }
        }
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(42);
        Command.writeInt(buf, 1 + (this.args != null ? this.args.count() : 0));
        buf.writeBytes(CRLF);
        buf.writeByte(36);
        Command.writeInt(buf, this.type.getBytes().length);
        buf.writeBytes(CRLF);
        buf.writeBytes(this.type.getBytes());
        buf.writeBytes(CRLF);
        if (this.args != null) {
            buf.writeBytes(this.args.buffer());
        }
    }

    protected static void writeInt(ByteBuf buf, int value) {
        if (value < 10) {
            buf.writeByte(48 + value);
            return;
        }
        StringBuilder sb = new StringBuilder(8);
        while (value > 0) {
            int digit = value % 10;
            sb.append((char)(48 + digit));
            value /= 10;
        }
        for (int i = sb.length() - 1; i >= 0; --i) {
            buf.writeByte((int)sb.charAt(i));
        }
    }

    @Override
    public String getError() {
        return this.output.getError();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.args;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [type=").append(this.type);
        sb.append(", output=").append(this.output);
        sb.append(']');
        return sb.toString();
    }

    public void setOutput(CommandOutput<K, V, T> output) {
        this.output = output;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public boolean setException(Throwable exception) {
        this.exception = exception;
        return true;
    }
}

