/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.models.slots;

import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import com.lambdaworks.redis.cluster.models.slots.ClusterSlotRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ClusterSlotsParser {
    private ClusterSlotsParser() {
    }

    public static List<ClusterSlotRange> parse(List<?> clusterSlotsOutput) {
        ArrayList result = Lists.newArrayList();
        for (Object o : clusterSlotsOutput) {
            List range;
            if (!(o instanceof List) || (range = (List)o).size() < 2) continue;
            ClusterSlotRange clusterSlotRange = ClusterSlotsParser.parseRange(range);
            result.add(clusterSlotRange);
        }
        Collections.sort(result, new Comparator<ClusterSlotRange>(){

            @Override
            public int compare(ClusterSlotRange o1, ClusterSlotRange o2) {
                return o1.getFrom() - o2.getFrom();
            }
        });
        return Collections.unmodifiableList(result);
    }

    private static ClusterSlotRange parseRange(List<?> range) {
        Iterator<?> iterator = range.iterator();
        int from = Ints.checkedCast((long)ClusterSlotsParser.getLongFromIterator(iterator, 0L));
        int to = Ints.checkedCast((long)ClusterSlotsParser.getLongFromIterator(iterator, 0L));
        HostAndPort master = null;
        ArrayList slaves = Lists.newArrayList();
        if (iterator.hasNext()) {
            master = ClusterSlotsParser.getHostAndPort(iterator);
        }
        while (iterator.hasNext()) {
            HostAndPort slave = ClusterSlotsParser.getHostAndPort(iterator);
            if (slave == null) continue;
            slaves.add(slave);
        }
        return new ClusterSlotRange(from, to, master, Collections.unmodifiableList(slaves));
    }

    private static HostAndPort getHostAndPort(Iterator<?> iterator) {
        Object element = iterator.next();
        if (element instanceof List) {
            List hostAndPortList = (List)element;
            if (hostAndPortList.size() != 2) {
                return null;
            }
            Iterator hostAndPortIterator = hostAndPortList.iterator();
            String host = (String)hostAndPortIterator.next();
            int port = Ints.checkedCast((long)ClusterSlotsParser.getLongFromIterator(hostAndPortIterator, 0L));
            HostAndPort hostAndPort = HostAndPort.fromParts((String)host, (int)port);
            return hostAndPort;
        }
        return null;
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }
}

