/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import com.lambdaworks.redis.ConnectionBuilder;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.JavaRuntime;
import com.lambdaworks.redis.PlainChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializerImpl;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.protocol.Command;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.List;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public class SslConnectionBuilder
extends ConnectionBuilder {
    private RedisURI redisURI;

    public static SslConnectionBuilder sslConnectionBuilder() {
        return new SslConnectionBuilder();
    }

    public SslConnectionBuilder ssl(RedisURI redisURI) {
        this.redisURI = redisURI;
        return this;
    }

    @Override
    protected List<ChannelHandler> buildHandlers() {
        Preconditions.checkState((this.redisURI != null ? 1 : 0) != 0, (Object)"redisURI must not be null");
        Preconditions.checkState((boolean)this.redisURI.isSsl(), (Object)"redisURI is not configured for SSL (ssl is false)");
        return super.buildHandlers();
    }

    @Override
    public RedisChannelInitializer build() {
        List<ChannelHandler> channelHandlers = this.buildHandlers();
        return new SslChannelInitializer(this.clientOptions().isPingBeforeActivateConnection(), channelHandlers, this.redisURI);
    }

    static class SslChannelInitializer
    extends ChannelInitializer<Channel>
    implements RedisChannelInitializer {
        private boolean pingBeforeActivate;
        private List<ChannelHandler> handlers;
        private SettableFuture<Boolean> initializedFuture = SettableFuture.create();
        private RedisURI redisURI;

        public SslChannelInitializer(boolean pingBeforeActivate, List<ChannelHandler> handlers, RedisURI redisURI) {
            this.pingBeforeActivate = pingBeforeActivate;
            this.handlers = handlers;
            this.redisURI = redisURI;
        }

        protected void initChannel(Channel channel) throws Exception {
            SslContext sslContext;
            SSLParameters sslParams = new SSLParameters();
            if (this.redisURI.isVerifyPeer()) {
                sslContext = SslContext.newClientContext((SslProvider)SslProvider.JDK);
                if (JavaRuntime.AT_LEAST_JDK_7) {
                    sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                }
            } else {
                sslContext = SslContext.newClientContext((SslProvider)SslProvider.JDK, (TrustManagerFactory)InsecureTrustManagerFactory.INSTANCE);
            }
            SSLEngine sslEngine = sslContext.newEngine(channel.alloc(), this.redisURI.getHost(), this.redisURI.getPort());
            sslEngine.setSSLParameters(sslParams);
            PlainChannelInitializer.removeIfExists(channel.pipeline(), SslHandler.class);
            SslHandler sslHandler = new SslHandler(sslEngine, this.redisURI.isStartTls());
            channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
            if (channel.pipeline().get("channelActivator") == null) {
                channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                    private Command<?, ?, ?> pingCommand;

                    @Override
                    public Future<Boolean> channelInitialized() {
                        return SslChannelInitializer.this.initializedFuture;
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        SslChannelInitializer.this.initializedFuture = SettableFuture.create();
                        this.pingCommand = null;
                        super.channelInactive(ctx);
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        if (SslChannelInitializer.this.initializedFuture.isDone()) {
                            super.channelActive(ctx);
                        }
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof SslHandshakeCompletionEvent && !SslChannelInitializer.this.initializedFuture.isDone()) {
                            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                            if (event.isSuccess()) {
                                if (SslChannelInitializer.this.pingBeforeActivate) {
                                    this.pingCommand = PlainChannelInitializer.INITIALIZING_CMD_BUILDER.ping();
                                    PlainChannelInitializer.pingBeforeActivate(this.pingCommand, (SettableFuture<Boolean>)SslChannelInitializer.this.initializedFuture, ctx, SslChannelInitializer.this.handlers);
                                } else {
                                    SslChannelInitializer.this.initializedFuture.set((Object)true);
                                    ctx.fireChannelActive();
                                }
                            } else {
                                SslChannelInitializer.this.initializedFuture.setException(event.cause());
                            }
                        }
                        if (evt instanceof ConnectionEvents.Close && ctx.channel().isOpen()) {
                            ctx.channel().close();
                        }
                        super.userEventTriggered(ctx, evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause instanceof SSLHandshakeException || cause.getCause() instanceof SSLException) {
                            SslChannelInitializer.this.initializedFuture.setException(cause);
                        }
                        super.exceptionCaught(ctx, cause);
                    }
                });
            }
            for (ChannelHandler handler : this.handlers) {
                PlainChannelInitializer.removeIfExists(channel.pipeline(), handler.getClass());
                channel.pipeline().addLast(new ChannelHandler[]{handler});
            }
        }

        @Override
        public Future<Boolean> channelInitialized() {
            return this.initializedFuture;
        }
    }
}

