/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.base.Preconditions;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.CloseEvents;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class RedisChannelHandler<K, V>
extends ChannelInboundHandlerAdapter
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisChannelHandler.class);
    protected long timeout;
    protected TimeUnit unit;
    private CloseEvents closeEvents = new CloseEvents();
    private boolean closed;
    private final RedisChannelWriter<K, V> channelWriter;
    private boolean active = true;
    private ClientOptions clientOptions;

    public RedisChannelHandler(RedisChannelWriter<K, V> writer, long timeout, TimeUnit unit) {
        this.channelWriter = writer;
        writer.setRedisChannelHandler(this);
        this.setTimeout(timeout, unit);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.closed = false;
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public synchronized void close() {
        logger.debug("close()");
        if (this.closed) {
            logger.warn("Client is already closed");
            return;
        }
        if (!this.closed) {
            this.active = false;
            this.closed = true;
            this.channelWriter.close();
            this.closeEvents.fireEventClosed(this);
            this.closeEvents = new CloseEvents();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.channelRead(msg);
    }

    public void channelRead(Object msg) {
    }

    protected <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        if (this.clientOptions != null && !this.clientOptions.isAutoReconnect() && !this.active) {
            cmd.setException(new RedisException("Connection is in a disconnected state and reconnect is disabled. Commands are not accepted."));
            cmd.complete();
            return cmd;
        }
        return this.channelWriter.write(cmd);
    }

    public void registerCloseables(final Collection<Closeable> registry, final Closeable ... closeables) {
        registry.addAll(Arrays.asList(closeables));
        this.addListener(new CloseEvents.CloseListener(){

            @Override
            public void resourceClosed(Object resource) {
                for (Closeable closeable : closeables) {
                    if (closeable == RedisChannelHandler.this) continue;
                    try {
                        closeable.close();
                    }
                    catch (IOException e) {
                        logger.debug(e.toString(), (Throwable)e);
                    }
                }
                registry.removeAll(Arrays.asList(closeables));
            }
        });
    }

    protected void addListener(CloseEvents.CloseListener listener) {
        this.closeEvents.addListener(listener);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void activated() {
        this.active = true;
        this.closed = false;
    }

    public void deactivated() {
        this.active = false;
    }

    public RedisChannelWriter<K, V> getChannelWriter() {
        return this.channelWriter;
    }

    public boolean isOpen() {
        return this.active;
    }

    public void reset() {
        this.channelWriter.reset();
    }

    public ClientOptions getOptions() {
        return this.clientOptions;
    }

    public void setOptions(ClientOptions clientOptions) {
        Preconditions.checkArgument((clientOptions != null ? 1 : 0) != 0, (Object)"clientOptions must not be null");
        this.clientOptions = clientOptions;
    }
}

