/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.util.concurrent.SettableFuture;
import com.lambdaworks.redis.ConnectionEvents;
import com.lambdaworks.redis.RedisChannelInitializer;
import com.lambdaworks.redis.RedisChannelInitializerImpl;
import com.lambdaworks.redis.RedisCommandBuilder;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

class PlainChannelInitializer
extends ChannelInitializer<Channel>
implements RedisChannelInitializer {
    static final RedisCommandBuilder INITIALIZING_CMD_BUILDER = new RedisCommandBuilder<String, String>(new Utf8StringCodec());
    protected boolean pingBeforeActivate;
    private List<ChannelHandler> handlers;
    protected SettableFuture<Boolean> initializedFuture = SettableFuture.create();

    public PlainChannelInitializer(boolean pingBeforeActivateConnection, List<ChannelHandler> handlers) {
        this.pingBeforeActivate = pingBeforeActivateConnection;
        this.handlers = handlers;
    }

    protected void initChannel(Channel channel) throws Exception {
        if (channel.pipeline().get("channelActivator") == null) {
            channel.pipeline().addLast("channelActivator", (ChannelHandler)new RedisChannelInitializerImpl(){
                private Command<?, ?, ?> pingCommand;

                @Override
                public Future<Boolean> channelInitialized() {
                    return PlainChannelInitializer.this.initializedFuture;
                }

                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                    PlainChannelInitializer.this.initializedFuture = SettableFuture.create();
                    this.pingCommand = null;
                    super.channelInactive(ctx);
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    super.channelRead(ctx, msg);
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof ConnectionEvents.Close && ctx.channel().isOpen()) {
                        ctx.channel().close();
                    }
                    super.userEventTriggered(ctx, evt);
                }

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    if (PlainChannelInitializer.this.pingBeforeActivate) {
                        this.pingCommand = INITIALIZING_CMD_BUILDER.ping();
                        PlainChannelInitializer.pingBeforeActivate(this.pingCommand, PlainChannelInitializer.this.initializedFuture, ctx, PlainChannelInitializer.this.handlers);
                    } else {
                        if (!PlainChannelInitializer.this.initializedFuture.isDone()) {
                            PlainChannelInitializer.this.initializedFuture.set((Object)true);
                        }
                        super.channelActive(ctx);
                    }
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    if (!PlainChannelInitializer.this.initializedFuture.isDone()) {
                        PlainChannelInitializer.this.initializedFuture.setException(cause);
                    }
                    super.exceptionCaught(ctx, cause);
                }
            });
        }
        for (ChannelHandler handler : this.handlers) {
            PlainChannelInitializer.removeIfExists(channel.pipeline(), handler.getClass());
            channel.pipeline().addLast(new ChannelHandler[]{handler});
        }
    }

    static void pingBeforeActivate(Command<?, ?, ?> cmd, SettableFuture<Boolean> initializedFuture, ChannelHandlerContext ctx, List<ChannelHandler> handlers) throws Exception {
        cmd.addListener(new PingResponseListener(initializedFuture, cmd, ctx), (Executor)ctx.executor());
        for (ChannelHandler handler : handlers) {
            if (!(handler instanceof CommandHandler)) continue;
            CommandHandler ch = (CommandHandler)handler;
            ch.write(ctx, cmd, ctx.newPromise());
            ctx.flush();
        }
    }

    static void removeIfExists(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerClass) {
        ChannelHandler channelHandler = pipeline.get(handlerClass);
        if (channelHandler != null) {
            pipeline.remove(channelHandler);
        }
    }

    @Override
    public Future<Boolean> channelInitialized() {
        return this.initializedFuture;
    }

    private static class PingResponseListener
    implements Runnable {
        private final SettableFuture<Boolean> initializedFuture;
        private final Command<?, ?, ?> cmd;
        private final ChannelHandlerContext ctx;

        public PingResponseListener(SettableFuture<Boolean> initializedFuture, Command<?, ?, ?> cmd, ChannelHandlerContext ctx) {
            this.initializedFuture = initializedFuture;
            this.cmd = cmd;
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.initializedFuture.isDone()) {
                if (this.cmd.getException() != null) {
                    this.initializedFuture.setException(this.cmd.getException());
                    return;
                }
                this.initializedFuture.set((Object)true);
                this.ctx.fireChannelActive();
            }
        }
    }
}

