/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.reflect.AbstractInvocationHandler;
import com.lambdaworks.redis.LettuceFutures;
import com.lambdaworks.redis.RedisAsyncConnectionImpl;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.protocol.RedisCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

class FutureSyncInvocationHandler<K, V>
extends AbstractInvocationHandler {
    private final RedisChannelHandler<K, V> connection;
    protected long timeout;
    protected TimeUnit unit;

    public FutureSyncInvocationHandler(RedisChannelHandler<K, V> connection) {
        this.connection = connection;
        this.timeout = connection.timeout;
        this.unit = connection.unit;
    }

    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getName().equals("setTimeout")) {
                this.setTimeout((Long)args[0], (TimeUnit)((Object)args[1]));
                return null;
            }
            Method targetMethod = this.connection.getClass().getMethod(method.getName(), method.getParameterTypes());
            Object result = targetMethod.invoke(this.connection, args);
            if (result instanceof RedisCommand) {
                RedisCommand command = (RedisCommand)result;
                if (!method.getName().equals("exec") && !method.getName().equals("multi") && this.connection instanceof RedisAsyncConnectionImpl && ((RedisAsyncConnectionImpl)this.connection).isMulti()) {
                    return null;
                }
                return LettuceFutures.await(command, this.timeout, this.unit);
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }
}

