/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SettableFuture;
import com.lambdaworks.redis.RedisChannelHandler;
import com.lambdaworks.redis.RedisConnectionStateListener;
import java.util.Set;

public class ConnectionEvents {
    private final Set<RedisConnectionStateListener> listeners = Sets.newConcurrentHashSet();

    protected void fireEventRedisConnected(RedisChannelHandler<?, ?> connection) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisConnected(connection);
        }
    }

    protected void fireEventRedisDisconnected(RedisChannelHandler<?, ?> connection) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisDisconnected(connection);
        }
    }

    protected void fireEventRedisExceptionCaught(RedisChannelHandler<?, ?> connection, Throwable cause) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisExceptionCaught(connection, cause);
        }
    }

    public void addListener(RedisConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        this.listeners.remove(listener);
    }

    public static class Close {
    }

    public static class PrepareClose {
        private SettableFuture<Boolean> prepareCloseFuture = SettableFuture.create();

        public SettableFuture<Boolean> getPrepareCloseFuture() {
            return this.prepareCloseFuture;
        }
    }
}

