/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.jul;

import biz.paluch.logging.gelf.GelfMessageAssembler;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.StaticMessageField;
import biz.paluch.logging.gelf.intern.Closer;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderFactory;
import biz.paluch.logging.gelf.jul.JulLogEvent;
import biz.paluch.logging.gelf.jul.JulPropertyProvider;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class GelfLogHandler
extends Handler
implements ErrorReporter {
    protected GelfSender gelfSender;
    protected GelfMessageAssembler gelfMessageAssembler = this.createGelfMessageAssembler();

    public GelfLogHandler() {
        this.initializeDefaultFields();
        JulPropertyProvider propertyProvider = new JulPropertyProvider(GelfLogHandler.class);
        this.gelfMessageAssembler.initialize(propertyProvider);
        String level = propertyProvider.getProperty("level");
        if (null != level) {
            this.setLevel(Level.parse(level.trim()));
        } else {
            this.setLevel(Level.INFO);
        }
        String additionalFields = propertyProvider.getProperty("additionalFields");
        if (null != level) {
            this.setAdditionalFields(additionalFields);
        }
        String filter = propertyProvider.getProperty("filter");
        try {
            if (null != filter) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(filter);
                this.setFilter((Filter)clazz.newInstance());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void initializeDefaultFields() {
        this.gelfMessageAssembler.addFields(LogMessageField.getDefaultMapping(LogMessageField.NamedLogField.Time, LogMessageField.NamedLogField.Severity, LogMessageField.NamedLogField.ThreadName, LogMessageField.NamedLogField.SourceClassName, LogMessageField.NamedLogField.SourceMethodName, LogMessageField.NamedLogField.SourceSimpleClassName, LogMessageField.NamedLogField.LoggerName));
    }

    protected GelfMessageAssembler createGelfMessageAssembler() {
        return new GelfMessageAssembler();
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        try {
            if (null == this.gelfSender) {
                this.gelfSender = GelfSenderFactory.createSender(this.gelfMessageAssembler, this);
            }
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e, 4);
            return;
        }
        try {
            GelfMessage message = this.createGelfMessage(record);
            if (!message.isValid()) {
                this.reportError("GELF Message is invalid: " + message.toJson(), null, 1);
                return;
            }
            if (null == this.gelfSender || !this.gelfSender.sendMessage(message)) {
                this.reportError("Could not send GELF message", null, 1);
            }
        }
        catch (Exception e) {
            this.reportError("Could not send GELF message: " + e.getMessage(), e, 5);
        }
    }

    @Override
    public void reportError(String message, Exception e) {
        this.reportError(message, e, 0);
    }

    @Override
    public void close() {
        if (null != this.gelfSender) {
            Closer.close(this.gelfSender);
            this.gelfSender = null;
        }
    }

    protected GelfMessage createGelfMessage(LogRecord record) {
        return this.gelfMessageAssembler.createGelfMessage(new JulLogEvent(record));
    }

    public void setAdditionalFields(String fieldSpec) {
        String[] properties;
        for (String field : properties = fieldSpec.split(",")) {
            int index = field.indexOf(61);
            if (-1 == index) continue;
            this.gelfMessageAssembler.addField(new StaticMessageField(field.substring(0, index), field.substring(index + 1)));
        }
    }

    public String getGraylogHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setGraylogHost(String graylogHost) {
        this.gelfMessageAssembler.setHost(graylogHost);
    }

    public String getOriginHost() {
        return this.gelfMessageAssembler.getOriginHost();
    }

    public void setOriginHost(String originHost) {
        this.gelfMessageAssembler.setOriginHost(originHost);
    }

    public String getHost() {
        return this.gelfMessageAssembler.getHost();
    }

    public void setHost(String host) {
        this.gelfMessageAssembler.setHost(host);
    }

    public int getPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setPort(int port) {
        this.gelfMessageAssembler.setPort(port);
    }

    public int getGraylogPort() {
        return this.gelfMessageAssembler.getPort();
    }

    public void setGraylogPort(int graylogPort) {
        this.gelfMessageAssembler.setPort(graylogPort);
    }

    public String getFacility() {
        return this.gelfMessageAssembler.getFacility();
    }

    public void setFacility(String facility) {
        this.gelfMessageAssembler.setFacility(facility);
    }

    public boolean isExtractStackTrace() {
        return this.gelfMessageAssembler.isExtractStackTrace();
    }

    public void setExtractStackTrace(boolean extractStacktrace) {
        this.gelfMessageAssembler.setExtractStackTrace(extractStacktrace);
    }

    public boolean isFilterStackTrace() {
        return this.gelfMessageAssembler.isFilterStackTrace();
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.gelfMessageAssembler.setFilterStackTrace(filterStackTrace);
    }

    public String getTimestampPattern() {
        return this.gelfMessageAssembler.getTimestampPattern();
    }

    public void setTimestampPattern(String timestampPattern) {
        this.gelfMessageAssembler.setTimestampPattern(timestampPattern);
    }

    public int getMaximumMessageSize() {
        return this.gelfMessageAssembler.getMaximumMessageSize();
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        this.gelfMessageAssembler.setMaximumMessageSize(maximumMessageSize);
    }
}

