/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.intern.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class LogMessageField
implements MessageField {
    private static final String DEFAULT_MAPPING = "default-logstash-fields.properties";
    private String name;
    private NamedLogField namedLogField;

    public LogMessageField(String name, NamedLogField namedLogField) {
        this.namedLogField = namedLogField;
        this.name = name;
    }

    public NamedLogField getNamedLogField() {
        return this.namedLogField;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LogMessageField> getDefaultMapping(NamedLogField ... supportedFields) {
        ArrayList<LogMessageField> result = new ArrayList<LogMessageField>();
        List<NamedLogField> supportedLogFields = Arrays.asList(supportedFields);
        InputStream is = null;
        try {
            is = LogMessageField.getStream();
            if (is == null) {
                System.out.println("No default-logstash-fields.properties resource present, using defaults");
            } else {
                Properties p = new Properties();
                p.load(is);
                if (!p.isEmpty()) {
                    LogMessageField.loadFields(p, result, supportedLogFields);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Could not parse default-logstash-fields.properties resource, using defaults");
        }
        finally {
            Closer.close(is);
        }
        if (result.isEmpty()) {
            for (NamedLogField namedLogField : NamedLogField.values()) {
                if (!supportedLogFields.contains((Object)namedLogField)) continue;
                result.add(new LogMessageField(namedLogField.fieldName, namedLogField));
            }
        }
        return result;
    }

    private static void loadFields(Properties p, List<LogMessageField> result, List<NamedLogField> supportedLogFields) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String targetName = entry.getKey().toString();
            String sourceFieldName = entry.getValue().toString();
            NamedLogField namedLogField = NamedLogField.byName(sourceFieldName);
            if (namedLogField == null || !supportedLogFields.contains((Object)namedLogField)) continue;
            result.add(new LogMessageField(targetName, namedLogField));
        }
    }

    private static InputStream getStream() {
        Thread thread = Thread.currentThread();
        InputStream is = LogMessageField.class.getResourceAsStream(DEFAULT_MAPPING);
        if (is == null && thread.getContextClassLoader() != null) {
            is = thread.getContextClassLoader().getResourceAsStream(DEFAULT_MAPPING);
        }
        return is;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [name='").append(this.name).append('\'');
        sb.append(", namedLogField=").append((Object)this.namedLogField);
        sb.append(']');
        return sb.toString();
    }

    public static enum NamedLogField {
        Time("Time"),
        Severity("Severity"),
        ThreadName("Thread"),
        SourceClassName("SourceClassName"),
        SourceSimpleClassName("SourceSimpleClassName"),
        SourceMethodName("SourceMethodName"),
        Server("Server"),
        LoggerName("LoggerName"),
        Marker("Marker"),
        NDC("NDC");

        private final String fieldName;

        private NamedLogField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public static NamedLogField byName(String name) {
            for (NamedLogField namedLogField : NamedLogField.values()) {
                if (!namedLogField.name().equalsIgnoreCase(name)) continue;
                return namedLogField;
            }
            return null;
        }
    }
}

