/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.gelf.intern.GelfMessage;
import java.util.HashMap;
import java.util.Map;

public class GelfMessageBuilder {
    private String version = "1.0";
    private String host;
    private String shortMessage;
    private String fullMessage;
    private long javaTimestamp;
    private String level;
    private String facility = "logstash-gelf";
    private Map<String, String> additonalFields = new HashMap<String, String>();
    private int maximumMessageSize = 8192;

    private GelfMessageBuilder() {
    }

    public static GelfMessageBuilder newInstance() {
        return new GelfMessageBuilder();
    }

    public GelfMessageBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public GelfMessageBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public GelfMessageBuilder withShortMessage(String shortMessage) {
        this.shortMessage = shortMessage;
        return this;
    }

    public GelfMessageBuilder withFullMessage(String fullMessage) {
        this.fullMessage = fullMessage;
        return this;
    }

    public GelfMessageBuilder withLevel(String level) {
        this.level = level;
        return this;
    }

    public GelfMessageBuilder withFacility(String facility) {
        this.facility = facility;
        return this;
    }

    public GelfMessageBuilder withMaximumMessageSize(int maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
        return this;
    }

    public GelfMessageBuilder withJavaTimestamp(long javaTimestamp) {
        this.javaTimestamp = javaTimestamp;
        return this;
    }

    public GelfMessageBuilder withFields(Map<String, String> additonalFields) {
        this.additonalFields.putAll(additonalFields);
        return this;
    }

    public GelfMessageBuilder withField(String key, String value) {
        this.additonalFields.put(key, value);
        return this;
    }

    public GelfMessage build() {
        GelfMessage gelfMessage = new GelfMessage(this.shortMessage, this.fullMessage, this.javaTimestamp, this.level);
        gelfMessage.addFields(this.additonalFields);
        gelfMessage.setMaximumMessageSize(this.maximumMessageSize);
        gelfMessage.setVersion(this.version);
        gelfMessage.setHost(this.host);
        gelfMessage.setJavaTimestamp(this.javaTimestamp);
        gelfMessage.setFacility(this.facility);
        return gelfMessage;
    }
}

