/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.parameters.test;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;

public class ParameterTestCase
extends TestCase {
    private static final String EOL = "\n";

    public ParameterTestCase(String name) {
        super(name);
    }

    public void testRemoveParameter() {
        Parameters parameters = new Parameters();
        parameters.setParameter("key1", "value1");
        Assert.assertEquals((int)1, (int)parameters.getNames().length);
        parameters.setParameter("key1", null);
        Assert.assertTrue((!parameters.isParameter("key1") ? 1 : 0) != 0);
        Assert.assertEquals((int)0, (int)parameters.getNames().length);
    }

    public void testIsParameter() {
        Parameters parameters = new Parameters();
        parameters.setParameter("key1", "value1");
        Assert.assertTrue((boolean)parameters.isParameter("key1"));
        Assert.assertTrue((!parameters.isParameter("key2") ? 1 : 0) != 0);
    }

    public void testGetParameter() {
        Parameters parameters = new Parameters();
        parameters.setParameter("key1", "value1");
        try {
            Assert.assertEquals((String)"value1", (String)parameters.getParameter("key1"));
        }
        catch (ParameterException pe) {
            Assert.fail((String)pe.getMessage());
        }
        try {
            parameters.getParameter("key2");
            Assert.fail((String)"Not inserted parameter 'key2' exists");
        }
        catch (ParameterException pe) {
            // empty catch block
        }
        Assert.assertEquals((String)"value1", (String)parameters.getParameter("key1", "value1-1"));
        Assert.assertEquals((String)"value2", (String)parameters.getParameter("key2", "value2"));
    }

    public void testFromConfiguration() {
        ByteArrayInputStream confInput = new ByteArrayInputStream("<?xml version=\"1.0\"?>\n<test>\n<parameter name=\"key1\" value=\"value1\"/>\n<parameter name=\"key2\" value=\"value2\"/>\n<parameter name=\"key3\" value=\"value3\"/>\n</test>".getBytes());
        try {
            DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
            Configuration configuration = builder.build(confInput);
            Parameters parameters = Parameters.fromConfiguration(configuration);
            Assert.assertEquals((String)"value1", (String)parameters.getParameter("key1"));
            Assert.assertEquals((String)"value2", (String)parameters.getParameter("key2"));
            Assert.assertEquals((String)"value3", (String)parameters.getParameter("key3"));
        }
        catch (ConfigurationException ce) {
            Assert.fail((String)("Converting failed: " + ce.getMessage()));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testFromProperties() {
        Properties properties = new Properties();
        properties.put("key1", "value1");
        properties.put("key2", "value2");
        properties.put("key3", "value3");
        Parameters parameters = Parameters.fromProperties(properties);
        try {
            Assert.assertEquals((String)"value1", (String)parameters.getParameter("key1"));
            Assert.assertEquals((String)"value2", (String)parameters.getParameter("key2"));
            Assert.assertEquals((String)"value3", (String)parameters.getParameter("key3"));
        }
        catch (ParameterException pe) {
            Assert.fail((String)pe.getMessage());
        }
    }
}

