/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public class ExceptionHelper {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void printException(Throwable e) {
        ExceptionHelper.printException(null, e);
    }

    public static void printException(String label, Throwable e) {
        ExceptionHelper.printException(label, e, null);
    }

    public static void printException(String label, Throwable e, Object source) {
        ExceptionHelper.printException(label, e, source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printException(String label, Throwable e, Object source, boolean trace) {
        PrintStream out;
        if (e == null) {
            throw new NullPointerException("throwable");
        }
        PrintStream printStream = out = System.err;
        synchronized (printStream) {
            out.println("===================================================================");
            if (label != null) {
                out.println("Message: " + label);
            }
            if (source != null) {
                out.println("Source: " + source);
            }
            out.println("Exception: " + e.toString());
            if (ExceptionHelper.getCause(e) != null) {
                ExceptionHelper.printCause(out, e);
            }
            out.println("===================================================================");
            if (trace) {
                Throwable root = ExceptionHelper.getLastThrowable(e);
                root.printStackTrace();
                out.println("===================================================================");
            }
        }
    }

    public static String packException(String message, Throwable e) {
        return ExceptionHelper.packException(message, e, true);
    }

    public static String packException(String message, Throwable e, boolean stack) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(message);
        if (e == null) {
            return buffer.toString();
        }
        buffer.append("\n");
        buffer.append("-------------------------------------------------------------------");
        buffer.append("\nException: " + e.getClass().getName());
        buffer.append("\nMessage: " + e.getMessage());
        ExceptionHelper.packCause(buffer, ExceptionHelper.getCause(e)).toString();
        Throwable root = ExceptionHelper.getLastThrowable(e);
        if (root != null && stack) {
            buffer.append("\n\n---- stack trace --------------------------------------------------");
            String[] trace = ExceptionHelper.captureStackTrace(root);
            int i = 0;
            while (i < trace.length) {
                buffer.append("\n" + trace[i]);
                ++i;
            }
        }
        buffer.append("\n-------------------------------------------------------------------");
        return buffer.toString();
    }

    private static StringBuffer packCause(StringBuffer buffer, Throwable cause) {
        if (cause == null) {
            return buffer;
        }
        buffer.append("\n\nCause: " + cause.getClass().getName());
        buffer.append("\nMessage: " + cause.getMessage());
        return ExceptionHelper.packCause(buffer, ExceptionHelper.getCause(cause));
    }

    private static Throwable getLastThrowable(Throwable exception) {
        Throwable cause = ExceptionHelper.getCause(exception);
        if (cause != null) {
            return ExceptionHelper.getLastThrowable(cause);
        }
        return exception;
    }

    private static Throwable getCause(Throwable exception) {
        if (exception == null) {
            throw new NullPointerException("exception");
        }
        try {
            Method method = exception.getClass().getMethod("getCause", new Class[0]);
            return (Throwable)method.invoke((Object)exception, new Object[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static String[] captureStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return ExceptionHelper.splitString(sw.toString(), LINE_SEPARATOR);
    }

    private static String[] splitString(String string, String onToken) {
        StringTokenizer tokenizer = new StringTokenizer(string, onToken);
        String[] result = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = tokenizer.nextToken();
            ++i;
        }
        return result;
    }

    private static void printCause(PrintStream out, Throwable e) {
        Throwable cause = ExceptionHelper.getCause(e);
        out.println("Cause: " + cause.toString());
        if (ExceptionHelper.getCause(cause) != null) {
            ExceptionHelper.printCause(out, cause);
        }
    }
}

