/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.assembly.appliance;

import java.util.ArrayList;
import org.apache.avalon.assembly.appliance.Appliance;
import org.apache.avalon.assembly.appliance.ApplianceRuntimeException;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

public class DependencyGraph {
    private final DependencyGraph m_parent;
    private final ArrayList m_appliances = new ArrayList();
    private final ArrayList m_children = new ArrayList();

    public DependencyGraph() {
        this(null);
    }

    public DependencyGraph(DependencyGraph parent) {
        this.m_parent = parent;
    }

    public void addChild(DependencyGraph child) {
        this.m_children.add(child);
    }

    public void removeChild(DependencyGraph child) {
        this.m_children.remove(child);
    }

    public void add(Appliance appliance) {
        if (!this.m_appliances.contains(appliance)) {
            this.m_appliances.add(appliance);
        }
    }

    public void remove(Appliance appliance) {
        this.m_appliances.remove(appliance);
    }

    public Appliance[] getStartupGraph() {
        try {
            return this.walkGraph(true);
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving startup graph.";
            throw new ApplianceRuntimeException("Unexpect error while resolving startup graph.", e);
        }
    }

    public Appliance[] getShutdownGraph() {
        try {
            return this.walkGraph(false);
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving shutdown graph.";
            throw new ApplianceRuntimeException("Unexpect error while resolving shutdown graph.", e);
        }
    }

    public Appliance[] getConsumerGraph(Appliance appliance) {
        try {
            return this.referencedAppliances(appliance, this.getComponentGraph(appliance, false));
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving consumer graph for appliance: " + appliance;
            throw new ApplianceRuntimeException(error, e);
        }
    }

    public Appliance[] getProviderGraph(Appliance appliance) {
        try {
            return this.referencedAppliances(appliance, this.getComponentGraph(appliance, true));
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving provider graph for: " + appliance;
            throw new ApplianceRuntimeException(error, e);
        }
    }

    private Appliance[] referencedAppliances(Appliance appliance, Appliance[] appliances) {
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        int i = 0;
        while (i < appliances.length) {
            if (!appliances[i].equals(appliance)) {
                list.add(appliances[i]);
            }
            ++i;
        }
        return list.toArray(new Appliance[0]);
    }

    private Appliance[] getComponentGraph(Appliance appliance, boolean providers) {
        ArrayList result = new ArrayList();
        this.visitcomponent(appliance, providers, new ArrayList(), result);
        Appliance[] returnValue = new Appliance[result.size()];
        return result.toArray(returnValue);
    }

    private Appliance[] walkGraph(boolean providers) {
        ArrayList result = new ArrayList();
        ArrayList done = new ArrayList();
        int size = this.m_appliances.size();
        int i = 0;
        while (i < size) {
            Appliance appliance = (Appliance)this.m_appliances.get(i);
            this.visitcomponent(appliance, providers, done, result);
            ++i;
        }
        Appliance[] returnValue = new Appliance[result.size()];
        return result.toArray(returnValue);
    }

    private void visitcomponent(Appliance appliance, boolean providers, ArrayList done, ArrayList order) {
        if (done.contains(appliance)) {
            return;
        }
        done.add(appliance);
        if (providers) {
            this.visitProviders(appliance, done, order);
        } else {
            this.visitConsumers(appliance, done, order);
        }
        order.add(appliance);
    }

    private void visitProviders(Appliance appliance, ArrayList done, ArrayList order) {
        Appliance contextProvider = appliance.getContextProvider();
        if (contextProvider != null) {
            this.visitcomponent(contextProvider, true, done, order);
        }
        StageDescriptor[] stages = appliance.getType().getStages();
        int i = stages.length - 1;
        while (i > -1) {
            StageDescriptor stage = stages[i];
            Appliance extension = appliance.getExtensionProvider(stage);
            if (extension != null) {
                this.visitcomponent(extension, true, done, order);
            }
            --i;
        }
        DependencyDescriptor[] descriptors = appliance.getDependencies();
        int i2 = 0;
        while (i2 < descriptors.length) {
            DependencyDescriptor dependency = descriptors[i2];
            Appliance provider = appliance.getServiceProvider(dependency.getKey());
            if (provider != null) {
                this.visitcomponent(provider, true, done, order);
            } else if (dependency.isRequired()) {
                throw new IllegalStateException("Unresolved service dependency for role: " + dependency.getKey() + " in appliance: " + appliance);
            }
            ++i2;
        }
    }

    private void visitConsumers(Appliance appliance, ArrayList done, ArrayList order) {
        String name = appliance.getName();
        int size = this.m_appliances.size();
        int i = 0;
        while (i < size) {
            Appliance other = (Appliance)this.m_appliances.get(i);
            Appliance[] providers = other.getServiceProviders();
            int j = 0;
            while (j < providers.length) {
                Appliance provider = providers[j];
                if (provider.equals(appliance)) {
                    this.visitcomponent(other, false, done, order);
                }
                ++j;
            }
            Appliance contextProvider = other.getContextProvider();
            if (contextProvider != null && contextProvider.equals(appliance)) {
                this.visitcomponent(other, false, done, order);
            }
            StageDescriptor[] stages = other.getType().getStages();
            int j2 = 0;
            while (j2 < stages.length) {
                StageDescriptor stage = stages[j2];
                Appliance extension = other.getExtensionProvider(stage);
                if (extension.equals(appliance)) {
                    this.visitcomponent(other, false, done, order);
                }
                ++j2;
            }
            ++i;
        }
        int childCount = this.m_children.size();
        int i2 = 0;
        while (i2 < childCount) {
            DependencyGraph map = (DependencyGraph)this.m_children.get(i2);
            map.visitConsumers(appliance, done, order);
            ++i2;
        }
    }
}

