/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder.tags;

import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.avalon.meta.info.CategoryDescriptor;
import org.apache.avalon.meta.info.builder.tags.AbstractTag;

public class LoggerTag
extends AbstractTag {
    protected static final String KEY = "logger";
    public static final String NAME_PARAM = "name";
    protected static final String LOGGER_CLASS = "org.apache.avalon.framework.logger.Logger";
    protected static final String DEPRECATED_LOGGER_CLASS = "org.apache.log.Logger";
    private JavaMethod[] m_methods;

    public LoggerTag(JavaClass clazz) {
        super(clazz);
        this.setMethods();
    }

    public CategoryDescriptor[] getCategories() {
        ArrayList<CategoryDescriptor> loggers = new ArrayList<CategoryDescriptor>();
        HashSet<String> marked = new HashSet<String>(10);
        for (int j = 0; j < this.m_methods.length; ++j) {
            DocletTag[] tags = this.m_methods[j].getTagsByName(this.getNS() + "." + KEY);
            for (int i = 0; i < tags.length; ++i) {
                String name = this.getNamedParameter(tags[i], NAME_PARAM, "");
                if (marked.contains(name)) continue;
                CategoryDescriptor logger = new CategoryDescriptor(name, null);
                loggers.add(logger);
                marked.add(name);
            }
        }
        return loggers.toArray(new CategoryDescriptor[loggers.size()]);
    }

    private void setMethods() {
        this.m_methods = this.getLifecycleMethods("enableLogging", LOGGER_CLASS);
        if (this.m_methods.length == 0) {
            this.m_methods = this.getLifecycleMethods("setLogger", DEPRECATED_LOGGER_CLASS);
        }
    }
}

