/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.Version;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.meta.ConfigurationBuilder;
import org.apache.avalon.meta.info.CategoryDescriptor;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.ExtensionDescriptor;
import org.apache.avalon.meta.info.InfoDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.builder.BuildException;
import org.apache.avalon.meta.info.builder.TypeFactory;
import org.apache.avalon.meta.info.builder.XMLLegacyCreator;
import org.apache.avalon.meta.info.builder.XMLServiceCreator;
import org.apache.excalibur.configuration.ConfigurationUtil;
import org.xml.sax.InputSource;

public class XMLTypeCreator
extends XMLServiceCreator
implements TypeFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$info$builder$XMLTypeCreator == null ? (class$org$apache$avalon$meta$info$builder$XMLTypeCreator = XMLTypeCreator.class$("org.apache.avalon.meta.info.builder.XMLTypeCreator")) : class$org$apache$avalon$meta$info$builder$XMLTypeCreator));
    static /* synthetic */ Class class$org$apache$avalon$meta$info$builder$XMLTypeCreator;

    public Type createType(String classname, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            throw new NullPointerException("input");
        }
        InputSource input = new InputSource(inputStream);
        Configuration xinfo = ConfigurationBuilder.build(input);
        return this.createType(classname, xinfo, null);
    }

    public Type createType(String classname, Configuration info, Configuration defaults) throws BuildException {
        String topLevelName = info.getName();
        if (topLevelName.equals("blockinfo")) {
            return new XMLLegacyCreator().createType(classname, info);
        }
        if (!topLevelName.equals("type")) {
            String message = REZ.getString("builder.bad-toplevel-element.error", (Object)classname, (Object)topLevelName);
            throw new BuildException(message);
        }
        Configuration configuration = null;
        configuration = info.getChild("info", false);
        InfoDescriptor descriptor = this.buildInfoDescriptor(classname, configuration);
        configuration = info.getChild("loggers");
        CategoryDescriptor[] loggers = this.buildLoggers(configuration);
        configuration = info.getChild("context");
        ContextDescriptor context = this.buildContext(configuration);
        configuration = info.getChild("services");
        ServiceDescriptor[] services = this.buildServices(configuration);
        configuration = info.getChild("dependencies");
        DependencyDescriptor[] dependencies = this.buildDependencies(configuration);
        configuration = info.getChild("stages");
        StageDescriptor[] phases = this.buildStages(configuration);
        configuration = info.getChild("extensions");
        ExtensionDescriptor[] extensions = this.buildExtensions(configuration);
        return new Type(descriptor, loggers, context, services, dependencies, phases, extensions, defaults);
    }

    protected StageDescriptor[] buildStages(Configuration config) throws BuildException {
        ArrayList<StageDescriptor> list = new ArrayList<StageDescriptor>();
        Configuration[] stages = config.getChildren("stage");
        for (int i = 0; i < stages.length; ++i) {
            StageDescriptor stage = this.buildPhase(stages[i]);
            list.add(stage);
        }
        return list.toArray(new StageDescriptor[0]);
    }

    protected StageDescriptor buildPhase(Configuration config) throws BuildException {
        try {
            String id = null;
            if (config.getAttribute("type", null) != null) {
                id = config.getAttribute("type");
            } else if (config.getAttribute("key", null) != null) {
                id = config.getAttribute("key");
            }
            if (id == null) {
                id = config.getAttribute("id");
            }
            Properties attributes = this.buildAttributes(config.getChild("attributes"));
            return new StageDescriptor(id, attributes);
        }
        catch (Throwable e) {
            String error = "Unable to construct a stage descriptor from source fragment:" + ConfigurationUtil.list((Configuration)config);
            throw new BuildException(error, e);
        }
    }

    protected ReferenceDescriptor buildReferenceDescriptor(Configuration service) throws BuildException {
        return this.buildReferenceDescriptor(service, null);
    }

    protected ReferenceDescriptor buildReferenceDescriptor(Configuration service, String classname) throws BuildException {
        String type = service.getAttribute("type", classname);
        if (type == null) {
            String error = "Missing 'type' attribute in configuration: " + ConfigurationUtil.list((Configuration)service);
            throw new BuildException(error);
        }
        if (type.indexOf(":") > -1) {
            return this.createReference(type);
        }
        String versionString = service.getAttribute("version", "1.0");
        Version version = this.buildVersion(versionString);
        return new ReferenceDescriptor(type, version);
    }

    protected CategoryDescriptor[] buildLoggers(Configuration configuration) throws BuildException {
        Configuration[] elements = configuration.getChildren("logger");
        ArrayList<CategoryDescriptor> loggers = new ArrayList<CategoryDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            CategoryDescriptor logger = this.buildLogger(elements[i]);
            loggers.add(logger);
        }
        return loggers.toArray(new CategoryDescriptor[loggers.size()]);
    }

    private CategoryDescriptor buildLogger(Configuration logger) throws BuildException {
        Properties attributes = this.buildAttributes(logger.getChild("attributes"));
        String name = logger.getAttribute("name", "");
        return new CategoryDescriptor(name, attributes);
    }

    public DependencyDescriptor[] buildDependencies(Configuration configuration) throws BuildException {
        Configuration[] elements = configuration.getChildren("dependency");
        ArrayList<DependencyDescriptor> dependencies = new ArrayList<DependencyDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            DependencyDescriptor dependency = this.buildDependency(elements[i]);
            dependencies.add(dependency);
        }
        return dependencies.toArray(new DependencyDescriptor[0]);
    }

    protected DependencyDescriptor buildDependency(Configuration dependency) throws BuildException {
        String role = dependency.getAttribute("role", null);
        if (role == null) {
            role = dependency.getAttribute("key", null);
        }
        ReferenceDescriptor reference = this.buildReferenceDescriptor(dependency);
        boolean optional = dependency.getAttributeAsBoolean("optional", false);
        Properties attributes = this.buildAttributes(dependency.getChild("attributes"));
        if (null == role) {
            role = reference.getClassname();
        }
        return new DependencyDescriptor(role, reference, optional, attributes);
    }

    protected ContextDescriptor buildContext(Configuration context) throws BuildException {
        EntryDescriptor[] entrys = this.buildEntries(context.getChildren("entry"));
        Properties attributes = this.buildAttributes(context.getChild("attributes"));
        String classname = context.getAttribute("type", null);
        return new ContextDescriptor(classname, entrys, attributes);
    }

    public ServiceDescriptor[] buildServices(Configuration servicesSet) throws BuildException {
        Configuration[] elements = servicesSet.getChildren("service");
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            ServiceDescriptor service = this.buildService(elements[i]);
            services.add(service);
        }
        return services.toArray(new ServiceDescriptor[0]);
    }

    public ServiceDescriptor buildService(Configuration service) throws BuildException {
        ReferenceDescriptor reference = this.buildReferenceDescriptor(service);
        Properties attributes = this.buildAttributes(service.getChild("attributes"));
        return new ServiceDescriptor(reference, attributes);
    }

    public InfoDescriptor buildInfoDescriptor(String classname, Configuration info) throws BuildException {
        String name = info.getChild("name").getValue(null);
        Version version = this.buildVersion(info.getChild("version").getValue("1.0"));
        String schema = info.getChild("schema").getValue(null);
        Properties attributes = this.buildAttributes(info.getChild("attributes"));
        String lifestyle = this.buildLifestyle(info, attributes);
        String collectionLegacy = info.getChild("lifestyle").getAttribute("collection", null);
        String collection = info.getChild("collection").getValue(collectionLegacy);
        return new InfoDescriptor(name, classname, version, lifestyle, collection, schema, attributes);
    }

    private String buildLifestyle(Configuration info, Properties attributes) {
        String lifestyle = info.getChild("lifestyle").getValue(null);
        if (lifestyle != null) {
            return lifestyle;
        }
        return attributes.getProperty("urn:avalon:lifestyle");
    }

    protected ExtensionDescriptor[] buildExtensions(Configuration config) throws BuildException {
        ArrayList<ExtensionDescriptor> list = new ArrayList<ExtensionDescriptor>();
        Configuration[] extensions = config.getChildren("extension");
        for (int i = 0; i < extensions.length; ++i) {
            list.add(this.buildExtension(extensions[i]));
        }
        return list.toArray(new ExtensionDescriptor[0]);
    }

    protected ExtensionDescriptor buildExtension(Configuration config) throws BuildException {
        if (config.getAttribute("type", null) != null) {
            String urn = config.getAttribute("type", null);
            Properties attributes = this.buildAttributes(config.getChild("attributes"));
            return new ExtensionDescriptor(urn, attributes);
        }
        String id = config.getAttribute("urn", null);
        if (id == null) {
            try {
                id = config.getAttribute("id");
            }
            catch (ConfigurationException e) {
                String error = "Missing extensions identifier 'id' attribute." + ConfigurationUtil.list((Configuration)config);
                throw new BuildException(error, (Throwable)e);
            }
        }
        Properties attributes = this.buildAttributes(config.getChild("attributes"));
        return new ExtensionDescriptor(id, attributes);
    }

    public ReferenceDescriptor createReference(String path) throws BuildException {
        Version version;
        String type;
        int index = path.indexOf(":");
        if (index > -1) {
            type = path.substring(0, index);
            version = this.buildVersion(path.substring(index + 1));
        } else {
            type = path;
            version = this.buildVersion("1.0.0");
        }
        return new ReferenceDescriptor(type, version);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

