/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.Version;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.meta.ConfigurationBuilder;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.builder.BuildException;
import org.apache.avalon.meta.info.builder.ServiceCreator;
import org.apache.excalibur.configuration.ConfigurationUtil;
import org.xml.sax.InputSource;

public class XMLServiceCreator
implements ServiceCreator {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$info$builder$XMLServiceCreator == null ? (class$org$apache$avalon$meta$info$builder$XMLServiceCreator = XMLServiceCreator.class$("org.apache.avalon.meta.info.builder.XMLServiceCreator")) : class$org$apache$avalon$meta$info$builder$XMLServiceCreator));
    static /* synthetic */ Class class$org$apache$avalon$meta$info$builder$XMLServiceCreator;

    public Service createService(String key, InputStream input) throws Exception {
        if (input == null) {
            throw new NullPointerException("input");
        }
        InputSource source = new InputSource(input);
        Configuration xservice = ConfigurationBuilder.build(source);
        return this.build(key, xservice);
    }

    private Service build(String classname, Configuration info) throws BuildException {
        String topLevelName = info.getName();
        if (!topLevelName.equals("service")) {
            String message = REZ.getString("builder.bad-toplevel-service-element.error", (Object)classname, (Object)topLevelName);
            throw new BuildException(message);
        }
        Properties attributes = this.buildAttributes(info.getChild("attributes"));
        EntryDescriptor[] entries = this.buildEntries(info.getChild("entries").getChildren("entry"));
        String versionString = info.getChild("version").getValue("1.0");
        Version version = this.buildVersion(versionString);
        return new Service(new ReferenceDescriptor(classname, version), entries, attributes);
    }

    public Properties buildAttributes(Configuration config) throws BuildException {
        Properties attributes = new Properties();
        Configuration[] children = config.getChildren("attribute");
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String key = null;
            try {
                key = child.getAttribute("key");
            }
            catch (ConfigurationException ce) {
                String error = "Missing 'key' attribute in 'attribute' element.\n" + ConfigurationUtil.list((Configuration)child);
                throw new BuildException(error, (Throwable)ce);
            }
            String value = null;
            try {
                value = child.getAttribute("value");
            }
            catch (Throwable e) {
                value = child.getValue("");
            }
            attributes.setProperty(key, value);
        }
        return attributes;
    }

    protected EntryDescriptor[] buildEntries(Configuration[] entrySet) throws BuildException {
        ArrayList<EntryDescriptor> entrys = new ArrayList<EntryDescriptor>();
        for (int i = 0; i < entrySet.length; ++i) {
            EntryDescriptor service = this.buildEntry(entrySet[i]);
            entrys.add(service);
        }
        return entrys.toArray(new EntryDescriptor[entrys.size()]);
    }

    protected EntryDescriptor buildEntry(Configuration config) throws BuildException {
        try {
            String key = config.getAttribute("key");
            String type = config.getAttribute("type", "java.lang.String");
            boolean isVolatile = config.getAttributeAsBoolean("volatile", false);
            boolean optional = config.getAttributeAsBoolean("optional", false);
            String alias = config.getAttribute("alias", null);
            return new EntryDescriptor(key, type, optional, isVolatile, alias);
        }
        catch (Throwable e) {
            String error = "Unable to build entry descriptor." + ConfigurationUtil.list((Configuration)config);
            throw new BuildException(error, e);
        }
    }

    protected Version buildVersion(String version) throws BuildException {
        try {
            return Version.getVersion((String)version);
        }
        catch (Throwable e) {
            String error = REZ.getString("builder.bad-version", (Object)version);
            throw new BuildException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

