/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.builder;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.Version;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.meta.ConfigurationBuilder;
import org.apache.avalon.meta.info.CategoryDescriptor;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.EntryDescriptor;
import org.apache.avalon.meta.info.ExtensionDescriptor;
import org.apache.avalon.meta.info.InfoDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.meta.info.Type;
import org.apache.avalon.meta.info.builder.BuildException;
import org.apache.avalon.meta.info.builder.TypeCreator;
import org.apache.avalon.meta.info.builder.XMLTypeCreator;
import org.apache.excalibur.configuration.ConfigurationUtil;
import org.xml.sax.InputSource;

public class XMLLegacyCreator
extends XMLTypeCreator
implements TypeCreator {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$meta$info$builder$XMLLegacyCreator == null ? (class$org$apache$avalon$meta$info$builder$XMLLegacyCreator = XMLLegacyCreator.class$("org.apache.avalon.meta.info.builder.XMLLegacyCreator")) : class$org$apache$avalon$meta$info$builder$XMLLegacyCreator));
    static /* synthetic */ Class class$org$apache$avalon$meta$info$builder$XMLLegacyCreator;

    public Type createType(String implementationKey, InputStream inputStream) throws Exception {
        if (inputStream == null) {
            throw new NullPointerException("input");
        }
        InputSource input = new InputSource(inputStream);
        String classname = implementationKey;
        Configuration xinfo = ConfigurationBuilder.build(input);
        return this.build(classname, xinfo);
    }

    public Type createType(String classname, Configuration config) throws BuildException {
        return this.build(classname, config);
    }

    private Type build(String classname, Configuration info) throws BuildException {
        String topLevelName = info.getName();
        if (!topLevelName.equals("blockinfo")) {
            String message = REZ.getString("builder.bad-toplevel-block-element.error", (Object)classname, (Object)topLevelName);
            throw new BuildException(message);
        }
        Configuration configuration = null;
        configuration = info.getChild("block");
        InfoDescriptor descriptor = this.buildInfoDescriptor(classname, configuration);
        configuration = info.getChild("loggers");
        CategoryDescriptor[] loggers = new CategoryDescriptor[]{};
        ContextDescriptor context = this.buildPhoenixContext();
        configuration = info.getChild("services");
        ServiceDescriptor[] services = this.buildBlockServices(configuration);
        configuration = info.getChild("dependencies");
        DependencyDescriptor[] dependencies = this.buildBlockDependencies(configuration);
        configuration = info.getChild("stages");
        StageDescriptor[] phases = this.buildStages(configuration);
        configuration = info.getChild("extensions");
        ExtensionDescriptor[] extensions = this.buildExtensions(configuration);
        return new Type(descriptor, loggers, context, services, dependencies, phases, extensions);
    }

    public InfoDescriptor buildInfoDescriptor(String classname, Configuration info) throws BuildException {
        String name = info.getChild("name").getValue(null);
        String schema = info.getChild("schema-type").getValue(null);
        Version version = this.buildVersion(info.getChild("version").getValue("1.0"));
        Properties attributes = this.buildAttributes(info.getChild("attributes"));
        String lifestyle = "singleton";
        return new InfoDescriptor(name, classname, version, "singleton", null, schema, attributes);
    }

    private ContextDescriptor buildPhoenixContext() {
        EntryDescriptor name = new EntryDescriptor("urn:avalon:name", "java.lang.String", false, false, "block.name");
        EntryDescriptor partition = new EntryDescriptor("urn:avalon:partition", "java.lang.String", false, false, "app.name");
        EntryDescriptor home = new EntryDescriptor("urn:avalon:home", "java.io.File", false, false, "app.home");
        return new ContextDescriptor(new EntryDescriptor[]{name, partition, home});
    }

    protected DependencyDescriptor[] buildBlockDependencies(Configuration depSet) throws BuildException {
        Configuration[] deps = depSet.getChildren("dependency");
        ArrayList<DependencyDescriptor> dependencies = new ArrayList<DependencyDescriptor>();
        for (int i = 0; i < deps.length; ++i) {
            DependencyDescriptor dependency = this.buildBlockDependency(deps[i]);
            dependencies.add(dependency);
        }
        return dependencies.toArray(new DependencyDescriptor[0]);
    }

    protected ServiceDescriptor[] buildBlockServices(Configuration servicesSet) throws BuildException {
        Configuration[] elements = servicesSet.getChildren("service");
        ArrayList<ServiceDescriptor> services = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < elements.length; ++i) {
            ServiceDescriptor service = this.buildBlockService(elements[i]);
            services.add(service);
        }
        return services.toArray(new ServiceDescriptor[0]);
    }

    protected ServiceDescriptor buildBlockService(Configuration service) throws BuildException {
        ReferenceDescriptor designator = this.buildReferenceDescriptor(service);
        Properties attributes = this.buildAttributes(service.getChild("attributes"));
        return new ServiceDescriptor(designator, attributes);
    }

    protected ReferenceDescriptor buildReferenceDescriptor(Configuration service) throws BuildException {
        try {
            String type = service.getAttribute("name");
            String versionString = service.getAttribute("version", "1.0");
            Version version = this.buildVersion(versionString);
            return new ReferenceDescriptor(type, version);
        }
        catch (Throwable e) {
            String error = "Error occured while attempting to build reference descriptor from legacy blockinfo configuration: " + ConfigurationUtil.list((Configuration)service);
            throw new BuildException(error, e);
        }
    }

    protected DependencyDescriptor buildBlockDependency(Configuration dependency) throws BuildException {
        try {
            Configuration serviceRef = dependency.getChild("service");
            ReferenceDescriptor service = this.buildReferenceDescriptor(serviceRef);
            boolean optional = dependency.getAttributeAsBoolean("optional", false);
            Properties attributes = this.buildAttributes(dependency.getChild("attributes"));
            String role = dependency.getChild("role").getValue(null);
            if (null == role) {
                role = service.getClassname();
            }
            return new DependencyDescriptor(role, service, optional, attributes);
        }
        catch (Throwable e) {
            String error = "Error occured while attempting to build dependency descriptor from legacy blockinfo descriptor: " + ConfigurationUtil.list((Configuration)dependency);
            throw new BuildException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

