/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.avalon.meta.info.Descriptor;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.writer.ServiceWriter;

public class XMLServiceWriter
implements ServiceWriter {
    public void writeService(Service service, OutputStream stream) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        this.writeHeader(writer);
        this.writeDoctype(writer, "service");
        writer.write("\n\n<service>");
        writer.write("\n  <version>");
        writer.write(service.getVersion().toString());
        writer.write("</version>");
        this.writeAttributes(writer, (Descriptor)service);
        writer.write("\n</service>");
        ((Writer)writer).flush();
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ?>");
    }

    private void writeDoctype(Writer writer, String root) throws IOException {
        String doctype = "\n<!DOCTYPE " + root + " PUBLIC \"-//AVALON/Service DTD Version 1.0//EN\" " + "\"http://avalon.apache.org/dtds/meta/service_1_0.dtd\" >";
        writer.write(doctype);
    }

    private void writeAttributes(Writer writer, Descriptor descriptor) throws IOException {
        String[] names = descriptor.getAttributeNames();
        if (names.length > 0) {
            writer.write("\n  <attributes>");
            for (int i = 0; i < names.length; ++i) {
                this.writeAttribute(writer, names[i], descriptor.getAttribute(names[i]));
            }
            writer.write("\n  </attributes>");
        }
    }

    private void writeAttribute(Writer writer, String key, String value) throws IOException {
        writer.write("\n    <attribute key=\"");
        writer.write(key);
        writer.write("\" value=\"");
        writer.write(value);
        writer.write("\"/>");
    }
}

