/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.io.Serializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.meta.info.CategoryDescriptor;
import org.apache.avalon.meta.info.ContextDescriptor;
import org.apache.avalon.meta.info.DependencyDescriptor;
import org.apache.avalon.meta.info.ExtensionDescriptor;
import org.apache.avalon.meta.info.InfoDescriptor;
import org.apache.avalon.meta.info.ReferenceDescriptor;
import org.apache.avalon.meta.info.SecurityDescriptor;
import org.apache.avalon.meta.info.ServiceDescriptor;
import org.apache.avalon.meta.info.StageDescriptor;

public class Type
implements Serializable {
    private final InfoDescriptor m_descriptor;
    private final SecurityDescriptor m_security;
    private final ContextDescriptor m_context;
    private final Configuration m_configuration;
    private final ServiceDescriptor[] m_services;
    private final DependencyDescriptor[] m_dependencies;
    private final CategoryDescriptor[] m_loggers;
    private final StageDescriptor[] m_stages;
    private final ExtensionDescriptor[] m_extensions;

    public Type(InfoDescriptor descriptor, CategoryDescriptor[] loggers, ContextDescriptor context, ServiceDescriptor[] services, DependencyDescriptor[] dependencies, StageDescriptor[] stages, ExtensionDescriptor[] extensions) throws NullPointerException {
        this(descriptor, loggers, context, services, dependencies, stages, extensions, null);
    }

    public Type(InfoDescriptor descriptor, CategoryDescriptor[] loggers, ContextDescriptor context, ServiceDescriptor[] services, DependencyDescriptor[] dependencies, StageDescriptor[] stages, ExtensionDescriptor[] extensions, Configuration defaults) throws NullPointerException {
        this(descriptor, new SecurityDescriptor(null, null), loggers, context, services, dependencies, stages, extensions, defaults);
    }

    public Type(InfoDescriptor descriptor, SecurityDescriptor security, CategoryDescriptor[] loggers, ContextDescriptor context, ServiceDescriptor[] services, DependencyDescriptor[] dependencies, StageDescriptor[] stages, ExtensionDescriptor[] extensions, Configuration defaults) throws NullPointerException {
        if (null == descriptor) {
            throw new NullPointerException("descriptor");
        }
        if (null == security) {
            throw new NullPointerException("security");
        }
        if (null == loggers) {
            throw new NullPointerException("loggers");
        }
        if (null == context) {
            throw new NullPointerException("context");
        }
        if (null == services) {
            throw new NullPointerException("services");
        }
        if (null == dependencies) {
            throw new NullPointerException("dependencies");
        }
        if (null == stages) {
            throw new NullPointerException("stages");
        }
        if (null == extensions) {
            throw new NullPointerException("extensions");
        }
        this.m_descriptor = descriptor;
        this.m_security = security;
        this.m_loggers = loggers;
        this.m_context = context;
        this.m_services = services;
        this.m_dependencies = dependencies;
        this.m_stages = stages;
        this.m_extensions = extensions;
        this.m_configuration = defaults;
    }

    public InfoDescriptor getInfo() {
        return this.m_descriptor;
    }

    public SecurityDescriptor getSecurity() {
        return this.m_security;
    }

    public CategoryDescriptor[] getCategories() {
        return this.m_loggers;
    }

    public boolean isaCategory(String name) {
        CategoryDescriptor[] loggers = this.getCategories();
        for (int i = 0; i < loggers.length; ++i) {
            CategoryDescriptor logger = loggers[i];
            if (!logger.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ContextDescriptor getContext() {
        return this.m_context;
    }

    public ServiceDescriptor[] getServices() {
        return this.m_services;
    }

    public ServiceDescriptor getService(ReferenceDescriptor reference) {
        for (int i = 0; i < this.m_services.length; ++i) {
            ServiceDescriptor service = this.m_services[i];
            if (!service.getReference().matches(reference)) continue;
            return service;
        }
        return null;
    }

    public ServiceDescriptor getService(String classname) {
        for (int i = 0; i < this.m_services.length; ++i) {
            ServiceDescriptor service = this.m_services[i];
            if (!service.getReference().getClassname().equals(classname)) continue;
            return service;
        }
        return null;
    }

    public DependencyDescriptor[] getDependencies() {
        return this.m_dependencies;
    }

    public DependencyDescriptor getDependency(String key) {
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            if (!this.m_dependencies[i].getKey().equals(key)) continue;
            return this.m_dependencies[i];
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public StageDescriptor[] getStages() {
        return this.m_stages;
    }

    public ExtensionDescriptor[] getExtensions() {
        return this.m_extensions;
    }

    public ExtensionDescriptor getExtension(StageDescriptor stage) {
        return this.getExtension(stage.getKey());
    }

    public ExtensionDescriptor getExtension(String key) {
        ExtensionDescriptor[] extensions = this.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            ExtensionDescriptor extension = extensions[i];
            String ref = extension.getKey();
            if (!key.equals(ref)) continue;
            return extension;
        }
        return null;
    }

    public String toString() {
        return this.getInfo().toString();
    }

    public boolean equals(Object other) {
        int i;
        if (!(other instanceof Type)) {
            return false;
        }
        Type t = (Type)other;
        if (!this.m_descriptor.equals(t.m_descriptor)) {
            return false;
        }
        if (!this.m_security.equals(t.m_security)) {
            return false;
        }
        if (!this.m_configuration.equals(t.m_configuration)) {
            return false;
        }
        if (!this.m_context.equals(t.m_context)) {
            return false;
        }
        for (i = 0; i < this.m_loggers.length; ++i) {
            if (this.m_loggers[i].equals(t.m_loggers[i])) continue;
            return false;
        }
        for (i = 0; i < this.m_services.length; ++i) {
            if (this.m_services[i].equals(t.m_services[i])) continue;
            return false;
        }
        for (i = 0; i < this.m_dependencies.length; ++i) {
            if (this.m_dependencies[i].equals(t.m_dependencies[i])) continue;
            return false;
        }
        for (i = 0; i < this.m_stages.length; ++i) {
            if (this.m_stages[i].equals(t.m_stages[i])) continue;
            return false;
        }
        for (i = 0; i < this.m_extensions.length; ++i) {
            if (this.m_extensions[i].equals(t.m_extensions[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int i;
        int hash = this.m_descriptor.hashCode();
        hash >>>= 13;
        hash ^= this.m_security.hashCode();
        hash >>>= 13;
        hash ^= this.m_context.hashCode();
        hash >>>= 13;
        if (this.m_configuration != null) {
            hash ^= this.m_context.hashCode();
            hash >>>= 13;
        }
        hash >>>= 13;
        for (i = 0; i < this.m_services.length; ++i) {
            hash ^= this.m_services[i].hashCode();
            hash >>>= 13;
        }
        for (i = 0; i < this.m_dependencies.length; ++i) {
            hash ^= this.m_dependencies[i].hashCode();
            hash >>>= 13;
        }
        for (i = 0; i < this.m_loggers.length; ++i) {
            hash ^= this.m_loggers[i].hashCode();
            hash >>>= 13;
        }
        for (i = 0; i < this.m_stages.length; ++i) {
            hash ^= this.m_stages[i].hashCode();
            hash >>>= 13;
        }
        for (i = 0; i < this.m_extensions.length; ++i) {
            hash ^= this.m_extensions[i].hashCode();
            hash >>>= 13;
        }
        return hash;
    }
}

