/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.io.Serializable;
import org.apache.avalon.framework.Version;
import org.apache.avalon.meta.info.Service;
import org.apache.avalon.meta.info.ServiceDescriptor;

public final class ReferenceDescriptor
implements Serializable {
    private final String m_classname;
    private final Version m_version;

    public ReferenceDescriptor(String type) throws NullPointerException {
        this(ReferenceDescriptor.parseClassname(type), ReferenceDescriptor.parseVersion(type));
    }

    public ReferenceDescriptor(String classname, Version version) throws NullPointerException {
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        if (classname.equals("")) {
            throw new IllegalArgumentException("classname");
        }
        if (classname.indexOf("/") > -1) {
            throw new IllegalArgumentException("classname");
        }
        this.m_classname = classname;
        this.m_version = null == version ? Version.getVersion((String)"") : version;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public Version getVersion() {
        return this.m_version;
    }

    public boolean matches(ReferenceDescriptor other) {
        if (!this.m_classname.equals(other.m_classname)) {
            return false;
        }
        return other.getVersion().complies(this.getVersion());
    }

    public String toString() {
        return this.getClassname() + ":" + this.getVersion();
    }

    public boolean equals(Object other) {
        boolean match = false;
        if (other instanceof ReferenceDescriptor) {
            match = ((ReferenceDescriptor)other).matches(this);
        } else if (other instanceof Service) {
            match = ((Service)other).matches(this);
        } else if (other instanceof ServiceDescriptor) {
            match = ((ServiceDescriptor)other).getReference().matches(this);
        }
        return match;
    }

    public int hashCode() {
        return this.getClassname().hashCode() ^ this.getVersion().hashCode();
    }

    private static final String parseClassname(String type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        int index = type.indexOf(":");
        if (index == -1) {
            return type;
        }
        return type.substring(0, index);
    }

    private static final Version parseVersion(String type) {
        if (type.indexOf(":") == -1) {
            return Version.getVersion((String)"1.0");
        }
        return Version.getVersion((String)type.substring(ReferenceDescriptor.getColonIndex(type) + 1));
    }

    private static final int getColonIndex(String type) {
        if (null == type) {
            throw new NullPointerException("type");
        }
        return Math.min(type.length(), Math.max(0, type.indexOf(":")));
    }
}

