/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.io.Serializable;

public final class PermissionDescriptor
implements Serializable {
    private static final String[] EMPTY_ACTIONS = new String[0];
    private final String m_classname;
    private final String m_name;
    private final String[] m_actions;

    public PermissionDescriptor(String classname, String name, String[] actions) {
        if (null == classname) {
            throw new NullPointerException("classname");
        }
        this.m_classname = classname;
        this.m_name = name;
        this.m_actions = null == actions ? EMPTY_ACTIONS : actions;
    }

    public String getClassname() {
        return this.m_classname;
    }

    public String getName() {
        return this.m_name;
    }

    public String[] getActions() {
        return this.m_actions;
    }

    public boolean equals(Object other) {
        boolean isEqual = other instanceof PermissionDescriptor;
        if (isEqual) {
            PermissionDescriptor permission = (PermissionDescriptor)other;
            boolean bl = isEqual = isEqual && this.m_classname.equals(permission.m_classname);
            isEqual = null == this.m_name ? isEqual && null == permission.m_name : isEqual && this.m_name.equals(permission.m_name);
            boolean bl2 = isEqual = isEqual && this.m_actions.length == permission.m_actions.length;
            if (isEqual) {
                for (int i = 0; i < this.m_actions.length; ++i) {
                    String action = this.m_actions[i];
                    if (action.equals(permission.m_actions[i])) continue;
                    return false;
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash >>>= 13;
        hash ^= this.m_classname.hashCode();
        hash >>>= 13;
        hash ^= null != this.m_name ? this.m_name.hashCode() : 0;
        hash >>>= 13;
        for (int i = 0; i < this.m_actions.length; ++i) {
            hash ^= this.m_actions[i].hashCode();
            hash >>>= 13;
        }
        return hash;
    }

    public String toString() {
        String list = "";
        for (int i = 0; i < this.m_actions.length; ++i) {
            list = list + this.m_actions[i];
            if (i >= this.m_actions.length - 1) continue;
            list = list + ", ";
        }
        return "[permission class=" + this.getClassname() + " name=" + this.getName() + " actions=" + list + "]";
    }
}

