/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.meta.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.avalon.meta.info.Descriptor;
import org.apache.avalon.meta.info.EntryDescriptor;

public class ContextDescriptor
extends Descriptor {
    public static final String NAME_KEY = "urn:avalon:name";
    public static final String PARTITION_KEY = "urn:avalon:partition";
    public static final String HOME_KEY = "urn:avalon:home";
    public static final String TEMP_KEY = "urn:avalon:temp";
    public static final String CLASSLOADER_KEY = "urn:avalon:classloader";
    public static final String STRATEGY_KEY = "urn:avalon:context.strategy";
    public static final String AVALON_CONTEXT_CLASSNAME = "org.apache.avalon.framework.context.Context";
    private final String m_classname;
    private final EntryDescriptor[] m_entries;

    public ContextDescriptor(EntryDescriptor[] entries) {
        this(null, entries, null);
    }

    public ContextDescriptor(String classname, EntryDescriptor[] entries) {
        this(classname, entries, null);
    }

    public ContextDescriptor(String classname, EntryDescriptor[] entries, Properties attributes) throws NullPointerException, IllegalArgumentException {
        super(attributes);
        if (null == entries) {
            throw new NullPointerException("entries");
        }
        this.m_classname = null == classname ? AVALON_CONTEXT_CLASSNAME : classname;
        this.m_entries = entries;
    }

    public String getContextInterfaceClassname() {
        return this.m_classname;
    }

    public EntryDescriptor[] getEntries() {
        return this.m_entries;
    }

    public EntryDescriptor getEntry(String alias) {
        EntryDescriptor entry;
        int i;
        if (null == alias) {
            throw new NullPointerException("alias");
        }
        for (i = 0; i < this.m_entries.length; ++i) {
            entry = this.m_entries[i];
            if (!entry.getAlias().equals(alias)) continue;
            return entry;
        }
        for (i = 0; i < this.m_entries.length; ++i) {
            entry = this.m_entries[i];
            if (!entry.getKey().equals(alias)) continue;
            return entry;
        }
        return null;
    }

    public EntryDescriptor[] merge(EntryDescriptor[] entries) throws IllegalArgumentException {
        for (int i = 0; i < entries.length; ++i) {
            EntryDescriptor entry = entries[i];
            String key = entry.getKey();
            EntryDescriptor local = this.getEntry(entry.getKey());
            if (local == null || entry.getClassname().equals(local.getClassname())) continue;
            String error = "Conflicting entry type for key: " + key;
            throw new IllegalArgumentException(error);
        }
        return this.join(entries, this.getEntries());
    }

    private EntryDescriptor[] join(EntryDescriptor[] primary, EntryDescriptor[] secondary) {
        ArrayList<EntryDescriptor> list = new ArrayList<EntryDescriptor>(primary.length + secondary.length);
        list.addAll(Arrays.asList(primary));
        list.addAll(Arrays.asList(secondary));
        return list.toArray(new EntryDescriptor[0]);
    }

    public boolean equals(Object other) {
        boolean isEqual = super.equals(other);
        if (isEqual) {
            isEqual = other instanceof ContextDescriptor;
        }
        if (isEqual) {
            ContextDescriptor entity = (ContextDescriptor)other;
            isEqual = isEqual && this.m_classname.equals(entity.m_classname);
            for (int i = 0; i < this.m_entries.length; ++i) {
                isEqual = isEqual && this.m_entries[i].equals(entity.m_entries[i]);
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash >>>= 7;
        hash ^= this.m_classname.hashCode();
        for (int i = 0; i < this.m_entries.length; ++i) {
            hash >>>= 7;
            hash ^= this.m_entries[i].hashCode();
        }
        return hash;
    }
}

