/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit.factory;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.logging.logkit.LogTargetException;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.logging.logkit.LogTargetManager;
import org.apache.avalon.logging.logkit.MissingIdException;
import org.apache.avalon.logging.logkit.UnknownLogTargetException;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;

public class MulticastTargetFactory
implements LogTargetFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory = MulticastTargetFactory.class$("org.apache.avalon.logging.logkit.factory.MulticastTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory));
    private final LogTargetManager m_manager;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory;

    public MulticastTargetFactory(LogTargetManager manager) {
        this.m_manager = manager;
    }

    public LogTarget createTarget(Configuration config) throws LogTargetException {
        Configuration[] references = config.getChildren("targetref");
        LogTarget[] targets = new LogTarget[references.length];
        for (int i = 0; i < references.length; ++i) {
            Configuration ref = references[i];
            String id = ref.getAttribute("id", null);
            if (null == id) {
                String error = REZ.getString("multicast.error.missing-id");
                throw new MissingIdException(error);
            }
            LogTarget target = this.m_manager.getLogTarget(id);
            if (null == target) {
                String error = REZ.getString("multicast.error.unknown-id", (Object)id);
                throw new UnknownLogTargetException(error);
            }
            targets[i] = target;
        }
        return new MulticastLogTarget(targets);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MulticastLogTarget
    implements LogTarget {
        private final LogTarget[] m_targets;

        public MulticastLogTarget(LogTarget[] targets) {
            this.m_targets = targets;
        }

        public void processEvent(LogEvent event) {
            for (int i = 0; i < this.m_targets.length; ++i) {
                this.m_targets[i].processEvent(event);
            }
        }
    }
}

