/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit.factory;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.logging.logkit.FormatterFactory;
import org.apache.avalon.logging.logkit.LogTargetException;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.rotate.FileStrategy;
import org.apache.log.output.io.rotate.OrRotateStrategy;
import org.apache.log.output.io.rotate.RevolvingFileStrategy;
import org.apache.log.output.io.rotate.RotateStrategy;
import org.apache.log.output.io.rotate.RotateStrategyByDate;
import org.apache.log.output.io.rotate.RotateStrategyBySize;
import org.apache.log.output.io.rotate.RotateStrategyByTime;
import org.apache.log.output.io.rotate.RotateStrategyByTimeOfDay;
import org.apache.log.output.io.rotate.RotatingFileTarget;
import org.apache.log.output.io.rotate.UniqueFileStrategy;

public class FileTargetFactory
implements LogTargetFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$factory$FileTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$FileTargetFactory = FileTargetFactory.class$("org.apache.avalon.logging.logkit.factory.FileTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$FileTargetFactory));
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long KILOBYTE = 1000L;
    private static final long MEGABYTE = 1000000L;
    private final File m_basedir;
    private final FormatterFactory m_formatter;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$FileTargetFactory;

    public FileTargetFactory(File basedir, FormatterFactory formatter) {
        this.m_basedir = basedir;
        this.m_formatter = formatter;
    }

    public final LogTarget createTarget(Configuration configuration) throws LogTargetException {
        try {
            Configuration confFilename = configuration.getChild("filename");
            String filename = confFilename.getValue();
            Configuration confRotation = configuration.getChild("rotation", false);
            Configuration confFormat = configuration.getChild("format", false);
            Configuration confAppend = configuration.getChild("append");
            boolean append = confAppend.getValueAsBoolean(false);
            File file = this.resolveFile(filename);
            Formatter formatter = this.m_formatter.createFormatter(confFormat);
            if (null == confRotation) {
                return new FileTarget(file, append, formatter);
            }
            if (confRotation.getChildren().length == 0) {
                String error = REZ.getString("file.error.missing-rotation");
                throw new LogTargetException(error);
            }
            Configuration confStrategy = confRotation.getChildren()[0];
            RotateStrategy rotateStrategy = this.getRotateStrategy(confStrategy);
            FileStrategy fileStrategy = this.getFileStrategy(confRotation, file);
            try {
                return new RotatingFileTarget(append, formatter, rotateStrategy, fileStrategy);
            }
            catch (Throwable e) {
                String error = REZ.getString("file.error.logkit-rotation");
                throw new LogTargetException(error, e);
            }
        }
        catch (IOException e) {
            String error = REZ.getString("file.error.io");
            throw new LogTargetException(error, (Throwable)e);
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("file.error.config");
            throw new LogTargetException(error, (Throwable)e);
        }
        catch (Throwable e) {
            String error = REZ.getString("file.error.internal");
            throw new LogTargetException(error, e);
        }
    }

    private File resolveFile(String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.m_basedir, filename);
    }

    private RotateStrategy getRotateStrategy(Configuration conf) {
        String type = conf.getName();
        if ("or".equals(type)) {
            Configuration[] configurations = conf.getChildren();
            int size = configurations.length;
            RotateStrategy[] strategies = new RotateStrategy[size];
            for (int i = 0; i < size; ++i) {
                strategies[i] = this.getRotateStrategy(configurations[i]);
            }
            return new OrRotateStrategy(strategies);
        }
        if ("size".equals(type)) {
            long size;
            String value = conf.getValue("2m");
            int count = value.length();
            char end = value.charAt(count - 1);
            switch (end) {
                case 'm': {
                    long no = Long.parseLong(value.substring(0, count - 1));
                    size = no * 1000000L;
                    break;
                }
                case 'k': {
                    long no = Long.parseLong(value.substring(0, count - 1));
                    size = no * 1000L;
                    break;
                }
                default: {
                    size = Long.parseLong(value);
                }
            }
            return new RotateStrategyBySize(size);
        }
        if ("date".equals(type)) {
            String value = conf.getValue("yyyyMMdd");
            return new RotateStrategyByDate(value);
        }
        if ("interval".equals(type)) {
            String value = conf.getValue("24:00:00");
            StringTokenizer tokenizer = new StringTokenizer(value, ":");
            int count = tokenizer.countTokens();
            long time = 0L;
            for (int i = count; i > 0; --i) {
                long no = Long.parseLong(tokenizer.nextToken());
                if (4 == i) {
                    time += no * 86400000L;
                }
                if (3 == i) {
                    time += no * 3600000L;
                }
                if (2 == i) {
                    time += no * 60000L;
                }
                if (1 != i) continue;
                time += no * 1000L;
            }
            return new RotateStrategyByTime(time);
        }
        String value = conf.getValue("24:00:00");
        StringTokenizer tokenizer = new StringTokenizer(value, ":");
        int count = tokenizer.countTokens();
        long time = 0L;
        for (int i = count; i > 0; --i) {
            long no = Long.parseLong(tokenizer.nextToken());
            if (3 == i) {
                time += no * 3600000L;
            }
            if (2 == i) {
                time += no * 60000L;
            }
            if (1 != i) continue;
            time += no * 1000L;
        }
        return new RotateStrategyByTimeOfDay(time);
    }

    protected FileStrategy getFileStrategy(Configuration conf, File file) {
        String type = conf.getAttribute("type", "unique");
        if ("revolving".equals(type)) {
            int initialRotation = conf.getAttributeAsInteger("init", 5);
            int maxRotation = conf.getAttributeAsInteger("max", 10);
            return new RevolvingFileStrategy(file, initialRotation, maxRotation);
        }
        String pattern = conf.getAttribute("pattern", null);
        String suffix = conf.getAttribute("suffix", null);
        if (pattern == null) {
            return new UniqueFileStrategy(file);
        }
        if (suffix == null) {
            return new UniqueFileStrategy(file, pattern);
        }
        return new UniqueFileStrategy(file, pattern, suffix);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

