/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit;

import java.io.OutputStream;
import org.apache.avalon.logging.data.CategoriesDirective;
import org.apache.avalon.logging.data.CategoryDirective;
import org.apache.avalon.logging.logkit.LogKitLogger;
import org.apache.avalon.logging.logkit.LogTargetManager;
import org.apache.avalon.logging.logkit.StandardFormatter;
import org.apache.avalon.logging.provider.LoggingException;
import org.apache.avalon.logging.provider.LoggingManager;
import org.apache.avalon.logging.provider.LoggingRuntimeException;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.StreamTarget;

public class DefaultLoggingManager
implements LoggingManager {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$DefaultLoggingManager == null ? (class$org$apache$avalon$logging$logkit$DefaultLoggingManager = DefaultLoggingManager.class$("org.apache.avalon.logging.logkit.DefaultLoggingManager")) : class$org$apache$avalon$logging$logkit$DefaultLoggingManager));
    private static final String DEFAULT_PRIORITY = "INFO";
    public static final String DEFAULT_FORMAT = "[%7.7{priority}] (%{category}): %{message}\\n%{throwable}";
    public static final Formatter FORMAT = new StandardFormatter("[%7.7{priority}] (%{category}): %{message}\\n%{throwable}");
    public static final Formatter CONSOLE = new StandardFormatter("[%7.7{priority}] (%{category}): %{message}\\n%{throwable}", false);
    private final LogTargetManager m_targets;
    private final Hierarchy m_hierarchy = new Hierarchy();
    private final boolean m_debug;
    private org.apache.avalon.framework.logger.Logger m_logger;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$DefaultLoggingManager;

    public DefaultLoggingManager(org.apache.avalon.framework.logger.Logger logger, LogTargetManager targets, CategoriesDirective categories, String channel, boolean debug) throws Exception {
        if (null == targets) {
            throw new NullPointerException("targets");
        }
        this.m_debug = debug;
        this.m_targets = targets;
        this.m_logger = logger;
        if (!debug) {
            String priority = this.getDefaultPriority(categories);
            this.getHierarchy().setDefaultPriority(Priority.getPriorityForName((String)priority));
        } else {
            this.getHierarchy().setDefaultPriority(Priority.getPriorityForName((String)"DEBUG"));
        }
        LogTarget target = this.getDefaultLogTarget(categories);
        this.getHierarchy().setDefaultLogTarget(target);
        this.addCategories(categories);
        this.m_logger = this.getLoggerForCategory(channel);
        this.m_logger.debug("logging system established");
    }

    private LogTarget getDefaultLogTarget(CategoriesDirective categories) throws LoggingException {
        String id = categories.getTarget();
        if (null == id) {
            return new StreamTarget((OutputStream)System.out, FORMAT);
        }
        LogTarget target = this.m_targets.getLogTarget(id);
        if (null != target) {
            return target;
        }
        String error = REZ.getString("manager.invalid-default-target", (Object)id);
        throw new LoggingException(error);
    }

    private String getDefaultPriority(CategoriesDirective categories) {
        String priority;
        if (null != categories && (priority = categories.getPriority()) != null) {
            return priority;
        }
        return DEFAULT_PRIORITY;
    }

    public void addCategories(CategoriesDirective descriptor) {
        this.addCategories("", descriptor);
    }

    public void addCategories(String root, CategoriesDirective directive) {
        String path = this.filter(root);
        this.addCategory(path, directive.getPriority(), directive.getTarget());
        CategoryDirective[] categories = directive.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            CategoryDirective category = categories[i];
            String name = this.filter(category.getName());
            String base = this.getBasePath(path, name);
            if (category instanceof CategoriesDirective) {
                CategoriesDirective c = (CategoriesDirective)category;
                this.addCategories(base, c);
                continue;
            }
            String priority = category.getPriority();
            String target = category.getTarget();
            this.addCategory(base, priority, target);
        }
    }

    private String getBasePath(String root, String name) {
        if (root.equals("")) {
            return name;
        }
        return this.filter(root + "." + name);
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(String category) {
        Logger log = this.addCategory(category, null, null);
        return new LogKitLogger(log);
    }

    private Logger addCategory(String path, String priority, String target) {
        return this.addCategory(path, priority, target, true);
    }

    private Logger addCategory(String path, String priority, String target, boolean notify) {
        LogTarget logTarget;
        Logger logger;
        String message;
        String name = this.filter(path);
        if (null != priority) {
            if (!name.equals("")) {
                message = REZ.getString("manager.notify.add-category-name-priority", (Object)name, (Object)priority.toLowerCase());
                this.debug(message);
            } else {
                message = REZ.getString("manager.notify.add-category-priority", (Object)priority.toLowerCase());
                this.debug(message);
            }
        } else if (!name.equals("")) {
            message = REZ.getString("manager.notify.add-category-name", (Object)name);
            this.debug(message);
        } else {
            message = REZ.getString("manager.notify.add-category");
            this.debug(message);
        }
        try {
            logger = this.getHierarchy().getLoggerFor(name);
        }
        catch (Throwable e) {
            String error = REZ.getString("manager.error.internal", (Object)name);
            throw new LoggingRuntimeException(error, e);
        }
        if (!this.m_debug && priority != null) {
            Priority priorityValue = Priority.getPriorityForName((String)priority);
            if (!priorityValue.getName().equals(priority)) {
                String message2 = REZ.getString("manager.error.priority", (Object)priority, (Object)name);
                throw new IllegalArgumentException(message2);
            }
            logger.setPriority(priorityValue);
        }
        if (target != null && !target.equals("default") && (logTarget = this.m_targets.getLogTarget(target)) != null) {
            logger.setLogTargets(new LogTarget[]{logTarget});
        }
        return logger;
    }

    private String filter(String name) {
        if (name == null) {
            return "";
        }
        String path = name.replace('/', '.');
        if (path.startsWith(".")) {
            path = path.substring(1);
            return this.filter(path);
        }
        if (path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
            return this.filter(path);
        }
        return path;
    }

    private Hierarchy getHierarchy() {
        return this.m_hierarchy;
    }

    private void debug(String message) {
        if (this.m_logger != null) {
            this.m_logger.debug(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

