/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.logging.data.CategoriesDirective;
import org.apache.avalon.logging.data.CategoryDirective;
import org.apache.avalon.logging.impl.ConsoleLogger;
import org.apache.avalon.logging.impl.DefaultLoggingCriteria;
import org.apache.avalon.logging.logkit.DefaultFormatterFactory;
import org.apache.avalon.logging.logkit.DefaultLogTargetFactoryBuilder;
import org.apache.avalon.logging.logkit.DefaultLogTargetFactoryManager;
import org.apache.avalon.logging.logkit.DefaultLogTargetManager;
import org.apache.avalon.logging.logkit.DefaultLoggingManager;
import org.apache.avalon.logging.logkit.FormatterFactory;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.logging.logkit.LogTargetFactoryBuilder;
import org.apache.avalon.logging.logkit.LogTargetFactoryManager;
import org.apache.avalon.logging.logkit.LogTargetManager;
import org.apache.avalon.logging.provider.LoggingCriteria;
import org.apache.avalon.logging.provider.LoggingException;
import org.apache.avalon.logging.provider.LoggingFactory;
import org.apache.avalon.logging.provider.LoggingManager;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.excalibur.configuration.ConfigurationUtil;
import org.apache.log.LogTarget;

public class DefaultLoggingFactory
implements LoggingFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$DefaultLoggingFactory == null ? (class$org$apache$avalon$logging$logkit$DefaultLoggingFactory = DefaultLoggingFactory.class$("org.apache.avalon.logging.logkit.DefaultLoggingFactory")) : class$org$apache$avalon$logging$logkit$DefaultLoggingFactory));
    private static final FormatterFactory FORMATTER = new DefaultFormatterFactory();
    private final ClassLoader m_classloader;
    private final InitialContext m_context;
    private Logger m_logger;
    private File m_basedir;
    private LogTargetFactoryManager m_factories;
    private LogTargetManager m_targets;
    private LogTargetFactoryBuilder m_builder;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$DefaultLoggingFactory;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$FileTargetFactory;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$StreamTargetFactory;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory;

    public DefaultLoggingFactory(InitialContext context, ClassLoader classloader) {
        this.m_context = context;
        this.m_classloader = classloader;
    }

    public LoggingCriteria createDefaultLoggingCriteria() {
        return new DefaultLoggingCriteria(this.m_context);
    }

    public LoggingManager createLoggingManager(LoggingCriteria criteria) throws LoggingException {
        try {
            return (LoggingManager)this.create((Map)criteria);
        }
        catch (Throwable e) {
            String error = "Cannot build logging manager.";
            throw new LoggingException("Cannot build logging manager.", e);
        }
    }

    public Map createDefaultCriteria() {
        return this.createDefaultLoggingCriteria();
    }

    public Object create() throws Exception {
        return this.create(this.createDefaultCriteria());
    }

    public Object create(Map map) throws Exception {
        Configuration config;
        if (null == map) {
            throw new NullPointerException("map");
        }
        LoggingCriteria criteria = this.getLoggingCriteria(map);
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        URL configURL = criteria.getLoggingConfiguration();
        if (configURL != null) {
            config = builder.build(configURL.toExternalForm());
        } else {
            InputStream defaultConf = this.getClass().getClassLoader().getResourceAsStream("org/apache/avalon/logging/logkit/default-logging.xml");
            config = builder.build(defaultConf);
        }
        this.m_logger = this.setUpBootstrapLogger(criteria, config);
        this.m_basedir = criteria.getBaseDirectory();
        HashMap factoriesMap = new HashMap();
        this.m_factories = new DefaultLogTargetFactoryManager(factoriesMap);
        HashMap targetsMap = new HashMap();
        this.m_targets = new DefaultLogTargetManager(targetsMap);
        this.m_builder = new DefaultLogTargetFactoryBuilder(this.m_context, this.m_classloader, this.m_logger, this.m_basedir, this.m_factories, this.m_targets);
        Configuration targetsConfig = config.getChild("targets");
        this.setupTargets(factoriesMap, targetsMap, targetsConfig);
        CategoriesDirective categories = this.getCategoriesDirective(config.getChild("categories"), true);
        String internal = config.getChild("logger").getAttribute("name", "logger");
        boolean debug = criteria.isDebugEnabled();
        DefaultLoggingManager manager = new DefaultLoggingManager(this.m_logger, this.m_targets, categories, internal, debug);
        return manager;
    }

    private LoggingCriteria getLoggingCriteria(Map map) {
        if (map instanceof LoggingCriteria) {
            return (LoggingCriteria)map;
        }
        String error = REZ.getString("factory.bad-criteria", (Object)map.getClass().getName());
        throw new IllegalArgumentException(error);
    }

    private Logger setUpBootstrapLogger(LoggingCriteria criteria, Configuration config) {
        if (config.getAttribute("debug", "false").equals("true")) {
            return new ConsoleLogger(0);
        }
        return criteria.getBootstrapLogger();
    }

    private void setupTargets(Map factories, Map targets, Configuration config) throws LoggingException {
        Configuration[] children = config.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Configuration child = children[i];
            String id = this.getTargetId(child);
            try {
                LogTarget target = this.createLogTarget(factories, id, child);
                targets.put(id, target);
                String message = REZ.getString("target.notice.add", (Object)id);
                this.m_logger.debug(message);
                continue;
            }
            catch (Throwable e) {
                String error = REZ.getString("target.notice.fail", (Object)id);
                this.m_logger.error(error, e);
                throw new LoggingException(error, e);
            }
        }
    }

    private LogTarget createLogTarget(Map factories, String id, Configuration config) throws LoggingException {
        String key = this.getTargetFactoryKey(config);
        LogTargetFactory factory = this.getLogTargetFactory(factories, key);
        return factory.createTarget(config);
    }

    private LogTargetFactory getLogTargetFactory(Map factories, String key) throws LoggingException {
        LogTargetFactory factory = this.m_factories.getLogTargetFactory(key);
        if (factory != null) {
            return factory;
        }
        Class clazz = this.getLogTargetFactoryClass(key);
        LogTargetFactory newFactory = this.m_builder.buildLogTargetFactory(clazz);
        factories.put(key, newFactory);
        return newFactory;
    }

    private Class getLogTargetFactoryClass(String key) throws LoggingException {
        if (key.equals("file")) {
            return class$org$apache$avalon$logging$logkit$factory$FileTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$FileTargetFactory = DefaultLoggingFactory.class$("org.apache.avalon.logging.logkit.factory.FileTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$FileTargetFactory;
        }
        if (key.equals("stream")) {
            return class$org$apache$avalon$logging$logkit$factory$StreamTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$StreamTargetFactory = DefaultLoggingFactory.class$("org.apache.avalon.logging.logkit.factory.StreamTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$StreamTargetFactory;
        }
        if (key.equals("multicast")) {
            return class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory = DefaultLoggingFactory.class$("org.apache.avalon.logging.logkit.factory.MulticastTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$MulticastTargetFactory;
        }
        if (key.equals("target")) {
            return class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory = DefaultLoggingFactory.class$("org.apache.avalon.logging.logkit.factory.PluginTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$PluginTargetFactory;
        }
        String message = REZ.getString("factory.error.unknown", (Object)key);
        throw new LoggingException(message);
    }

    private String getTargetFactoryKey(Configuration config) throws LoggingException {
        return config.getName();
    }

    private String getTargetId(Configuration config) throws LoggingException {
        try {
            return config.getAttribute("id");
        }
        catch (ConfigurationException e) {
            String listing = ConfigurationUtil.list((Configuration)config);
            String error = REZ.getString("target.error.missing-id", (Object)listing);
            throw new LoggingException(error);
        }
    }

    private CategoriesDirective getCategoriesDirective(Configuration config) throws LoggingException {
        return this.getCategoriesDirective(config, false);
    }

    private CategoriesDirective getCategoriesDirective(Configuration config, boolean root) throws LoggingException {
        String name = this.getCategoryName(config, root);
        String priority = config.getAttribute("priority", null);
        String target = config.getAttribute("target", null);
        CategoryDirective[] categories = this.getCategoryDirectives(config);
        return new CategoriesDirective(name, priority, target, categories);
    }

    private String getCategoryName(Configuration config, boolean root) throws LoggingException {
        if (root) {
            return "";
        }
        String name = config.getAttribute("name", null);
        if (null != name) {
            return name;
        }
        String error = REZ.getString("target.error.missing-category-name");
        throw new LoggingException(error);
    }

    private CategoryDirective[] getCategoryDirectives(Configuration config) throws LoggingException {
        ArrayList<CategoryDirective> list = new ArrayList<CategoryDirective>();
        Configuration[] children = config.getChildren();
        for (int i = 0; i < children.length; ++i) {
            CategoryDirective directive;
            Configuration child = children[i];
            if (child.getName().equals("category")) {
                directive = this.getCategoryDirective(child);
                list.add(directive);
                continue;
            }
            if (!child.getName().equals("categories")) continue;
            directive = this.getCategoriesDirective(child);
            list.add(directive);
        }
        return list.toArray(new CategoryDirective[0]);
    }

    private CategoryDirective getCategoryDirective(Configuration config) throws LoggingException {
        String name = this.getCategoryName(config, false);
        String priority = config.getAttribute("priority", null);
        String target = config.getAttribute("target", null);
        return new CategoryDirective(name, priority, target);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

