/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit;

import java.io.File;
import java.lang.reflect.Constructor;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.logging.logkit.DefaultFormatterFactory;
import org.apache.avalon.logging.logkit.FormatterFactory;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.logging.logkit.LogTargetFactoryBuilder;
import org.apache.avalon.logging.logkit.LogTargetFactoryManager;
import org.apache.avalon.logging.logkit.LogTargetManager;
import org.apache.avalon.logging.provider.LoggingException;
import org.apache.avalon.repository.provider.InitialContext;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultLogTargetFactoryBuilder
implements LogTargetFactoryBuilder {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$DefaultLogTargetFactoryBuilder == null ? (class$org$apache$avalon$logging$logkit$DefaultLogTargetFactoryBuilder = DefaultLogTargetFactoryBuilder.class$("org.apache.avalon.logging.logkit.DefaultLogTargetFactoryBuilder")) : class$org$apache$avalon$logging$logkit$DefaultLogTargetFactoryBuilder));
    private static final FormatterFactory FORMATTER = new DefaultFormatterFactory();
    private final ClassLoader m_classloader;
    private final InitialContext m_context;
    private final Logger m_logger;
    private final File m_basedir;
    private final LogTargetFactoryManager m_factories;
    private final LogTargetManager m_targets;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$DefaultLogTargetFactoryBuilder;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$LogTargetFactoryManager;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$LogTargetManager;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$FormatterFactory;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$apache$avalon$repository$provider$InitialContext;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$LogTargetFactoryBuilder;

    public DefaultLogTargetFactoryBuilder(InitialContext context, ClassLoader classloader, Logger logger, File basedir, LogTargetFactoryManager factories, LogTargetManager targets) {
        this.m_context = context;
        this.m_classloader = classloader;
        this.m_logger = logger;
        this.m_basedir = basedir;
        this.m_factories = factories;
        this.m_targets = targets;
    }

    public LogTargetFactory buildLogTargetFactory(Class clazz) throws LoggingException {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length < 1) {
            String error = REZ.getString("factory.error.no-constructor", (Object)clazz.getName());
            throw new LoggingException(error);
        }
        Constructor<?> constructor = constructors[0];
        Class<?>[] classes = constructor.getParameterTypes();
        Object[] args = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<?> c;
            if ((class$java$io$File == null ? DefaultLogTargetFactoryBuilder.class$("java.io.File") : class$java$io$File).isAssignableFrom(c = classes[i])) {
                args[i] = this.m_basedir;
                continue;
            }
            if ((class$org$apache$avalon$framework$logger$Logger == null ? DefaultLogTargetFactoryBuilder.class$("org.apache.avalon.framework.logger.Logger") : class$org$apache$avalon$framework$logger$Logger).isAssignableFrom(c)) {
                args[i] = this.m_logger;
                continue;
            }
            if ((class$org$apache$avalon$logging$logkit$LogTargetFactoryManager == null ? DefaultLogTargetFactoryBuilder.class$("org.apache.avalon.logging.logkit.LogTargetFactoryManager") : class$org$apache$avalon$logging$logkit$LogTargetFactoryManager).isAssignableFrom(c)) {
                args[i] = this.m_factories;
                continue;
            }
            if ((class$org$apache$avalon$logging$logkit$LogTargetManager == null ? DefaultLogTargetFactoryBuilder.class$("org.apache.avalon.logging.logkit.LogTargetManager") : class$org$apache$avalon$logging$logkit$LogTargetManager).isAssignableFrom(c)) {
                args[i] = this.m_targets;
                continue;
            }
            if ((class$org$apache$avalon$logging$logkit$FormatterFactory == null ? DefaultLogTargetFactoryBuilder.class$("org.apache.avalon.logging.logkit.FormatterFactory") : class$org$apache$avalon$logging$logkit$FormatterFactory).isAssignableFrom(c)) {
                args[i] = FORMATTER;
                continue;
            }
            if ((class$java$lang$ClassLoader == null ? DefaultLogTargetFactoryBuilder.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader).isAssignableFrom(c)) {
                args[i] = this.m_classloader;
                continue;
            }
            if ((class$org$apache$avalon$repository$provider$InitialContext == null ? DefaultLogTargetFactoryBuilder.class$("org.apache.avalon.repository.provider.InitialContext") : class$org$apache$avalon$repository$provider$InitialContext).isAssignableFrom(c)) {
                args[i] = this.m_context;
                continue;
            }
            if ((class$org$apache$avalon$logging$logkit$LogTargetFactoryBuilder == null ? DefaultLogTargetFactoryBuilder.class$("org.apache.avalon.logging.logkit.LogTargetFactoryBuilder") : class$org$apache$avalon$logging$logkit$LogTargetFactoryBuilder).isAssignableFrom(c)) {
                args[i] = this;
                continue;
            }
            String error = REZ.getString("factory.error.unrecognized-parameter", (Object)c.getName(), (Object)clazz.getName());
            throw new LoggingException(error);
        }
        return this.instantiateLogTargetFactory(constructor, args);
    }

    private LogTargetFactory instantiateLogTargetFactory(Constructor constructor, Object[] args) throws LoggingException {
        Class clazz = constructor.getDeclaringClass();
        try {
            return (LogTargetFactory)constructor.newInstance(args);
        }
        catch (Throwable e) {
            String error = REZ.getString("target.error.instantiation", (Object)clazz.getName());
            throw new LoggingException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

