/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.logging.logkit.FormatterFactory;
import org.apache.avalon.logging.logkit.StandardFormatter;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.format.SyslogFormatter;
import org.apache.log.format.XMLFormatter;

public class DefaultFormatterFactory
implements FormatterFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$DefaultFormatterFactory == null ? (class$org$apache$avalon$logging$logkit$DefaultFormatterFactory = DefaultFormatterFactory.class$("org.apache.avalon.logging.logkit.DefaultFormatterFactory")) : class$org$apache$avalon$logging$logkit$DefaultFormatterFactory));
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$DefaultFormatterFactory;

    public Formatter createFormatter(Configuration config) {
        if (null == config) {
            return new StandardFormatter("[%7.7{priority}] (%{category}): %{message}\\n%{throwable}");
        }
        String type = config.getAttribute("type", "pattern");
        String format = config.getValue("[%7.7{priority}] (%{category}): %{message}\\n%{throwable}");
        return this.createFormatter(type, format);
    }

    public Formatter createFormatter(String type, String format) {
        if ("avalon".equals(type)) {
            return new StandardFormatter(format, true);
        }
        if ("console".equals(type)) {
            return new StandardFormatter(format, false);
        }
        if ("extended".equals(type)) {
            return new ExtendedPatternFormatter(format, 1);
        }
        if ("raw".equals(type)) {
            return new RawFormatter();
        }
        if ("xml".equals(type)) {
            return new XMLFormatter();
        }
        if ("syslog".equals(type)) {
            return new SyslogFormatter();
        }
        if ("pattern".equals(type)) {
            return new PatternFormatter(format);
        }
        String error = REZ.getString("formatter.error.unknown-type", (Object)type);
        throw new IllegalArgumentException(error);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

