/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.logging.logkit.factory.datagram;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.logging.logkit.FormatterFactory;
import org.apache.avalon.logging.logkit.LogTargetException;
import org.apache.avalon.logging.logkit.LogTargetFactory;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;
import org.apache.log.LogTarget;
import org.apache.log.format.Formatter;
import org.apache.log.output.net.DatagramOutputTarget;

public class DatagramTargetFactory
implements LogTargetFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$logging$logkit$factory$datagram$DatagramTargetFactory == null ? (class$org$apache$avalon$logging$logkit$factory$datagram$DatagramTargetFactory = DatagramTargetFactory.class$("org.apache.avalon.logging.logkit.factory.datagram.DatagramTargetFactory")) : class$org$apache$avalon$logging$logkit$factory$datagram$DatagramTargetFactory));
    private final FormatterFactory m_formatter;
    static /* synthetic */ Class class$org$apache$avalon$logging$logkit$factory$datagram$DatagramTargetFactory;

    public DatagramTargetFactory(FormatterFactory formatter) {
        this.m_formatter = formatter;
    }

    public LogTarget createTarget(Configuration conf) throws LogTargetException {
        InetAddress address;
        Configuration configChild = conf.getChild("address", false);
        if (null == configChild) {
            String error = REZ.getString("datagram.error.missing-address");
            throw new LogTargetException(error);
        }
        try {
            address = InetAddress.getByName(configChild.getAttribute("hostname"));
        }
        catch (UnknownHostException uhex) {
            String error = REZ.getString("datagram.error.unknown-host");
            throw new LogTargetException(error, (Throwable)uhex);
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("datagram.error.missing-host");
            throw new LogTargetException(error, (Throwable)e);
        }
        Configuration formatConfig = conf.getChild("format");
        Formatter formatter = this.m_formatter.createFormatter(formatConfig);
        try {
            int port = configChild.getAttributeAsInteger("port");
            return new DatagramOutputTarget(address, port, formatter);
        }
        catch (IOException ioex) {
            String error = REZ.getString("datagram.error.internal");
            throw new LogTargetException(error, (Throwable)ioex);
        }
        catch (ConfigurationException e) {
            String error = REZ.getString("datagram.error.missing-port");
            throw new LogTargetException(error, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

