/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.extension.manager.impl;

import java.util.Comparator;
import org.apache.avalon.extension.DeweyDecimal;
import org.apache.avalon.extension.Extension;
import org.apache.avalon.extension.manager.OptionalPackage;

class OptionalPackageComparator
implements Comparator {
    private final String m_name;

    public OptionalPackageComparator(String name) {
        if (null == name) {
            throw new NullPointerException("name");
        }
        this.m_name = name;
    }

    public int compare(Object o1, Object o2) {
        Extension e2;
        OptionalPackage pkg1 = (OptionalPackage)o1;
        OptionalPackage pkg2 = (OptionalPackage)o2;
        Extension e1 = this.getMatchingExtension(pkg1);
        int result = this.compareSpecVersion(e1, e2 = this.getMatchingExtension(pkg2));
        if (0 != result) {
            return result;
        }
        return this.compareImplVersion(e1, e2);
    }

    private Extension getMatchingExtension(OptionalPackage pkg) {
        Extension[] extensions = pkg.getAvailableExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!extension.getExtensionName().equals(this.m_name)) continue;
            return extension;
        }
        String message = "Unable to locate extension " + this.m_name + " in package " + pkg;
        throw new IllegalStateException(message);
    }

    private int compareImplVersion(Extension e1, Extension e2) {
        String implVersion1 = e1.getImplementationVersion();
        String implVersion2 = e2.getImplementationVersion();
        if (null == implVersion1 && null == implVersion2) {
            return 0;
        }
        if (null != implVersion1 && null == implVersion2) {
            return -1;
        }
        if (null == implVersion1 && null != implVersion2) {
            return 1;
        }
        return -implVersion1.compareTo(implVersion2);
    }

    private int compareSpecVersion(Extension e1, Extension e2) {
        DeweyDecimal specVersion1 = e1.getSpecificationVersion();
        DeweyDecimal specVersion2 = e2.getSpecificationVersion();
        if (null == specVersion1 && null == specVersion2) {
            return 0;
        }
        if (null != specVersion1 && null == specVersion2) {
            return -1;
        }
        if (null == specVersion1 && null != specVersion2) {
            return 1;
        }
        if (specVersion1.isEqual(specVersion2)) {
            return 0;
        }
        if (specVersion1.isGreaterThan(specVersion2)) {
            return -1;
        }
        return 1;
    }
}

