/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.appliance;

import java.util.AbstractCollection;
import java.util.ArrayList;
import org.apache.avalon.activation.appliance.Appliance;
import org.apache.avalon.activation.appliance.ApplianceRuntimeException;
import org.apache.avalon.activation.appliance.Composite;

public class DependencyGraph {
    private final DependencyGraph m_parent;
    private final ArrayList m_appliances = new ArrayList();
    private final ArrayList m_children = new ArrayList();

    public DependencyGraph() {
        this(null);
    }

    public DependencyGraph(DependencyGraph parent) {
        this.m_parent = parent;
    }

    public void addChild(DependencyGraph child) {
        this.m_children.add(child);
    }

    public void removeChild(DependencyGraph child) {
        ((AbstractCollection)this.m_children).remove(child);
    }

    public void add(Appliance appliance) {
        if (!this.m_appliances.contains(appliance)) {
            this.m_appliances.add(appliance);
        }
    }

    public void remove(Appliance appliance) {
        ((AbstractCollection)this.m_appliances).remove(appliance);
    }

    public Appliance[] getStartupGraph() {
        try {
            return this.walkGraph(true);
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving startup graph.";
            throw new ApplianceRuntimeException("Unexpect error while resolving startup graph.", e);
        }
    }

    public Appliance[] getShutdownGraph() {
        try {
            return this.walkGraph(false);
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving shutdown graph.";
            throw new ApplianceRuntimeException("Unexpect error while resolving shutdown graph.", e);
        }
    }

    public Appliance[] getConsumerGraph(Appliance appliance) {
        try {
            return this.referencedAppliances(appliance, this.getComponentGraph(appliance, false));
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving consumer graph for appliance: " + appliance;
            throw new ApplianceRuntimeException(error, e);
        }
    }

    public Appliance[] getProviderGraph(Appliance appliance) {
        try {
            return this.referencedAppliances(appliance, this.getComponentGraph(appliance, true));
        }
        catch (Throwable e) {
            String error = "Unexpect error while resolving provider graph for: " + appliance;
            throw new ApplianceRuntimeException(error, e);
        }
    }

    private Appliance[] referencedAppliances(Appliance appliance, Appliance[] appliances) {
        ArrayList<Appliance> list = new ArrayList<Appliance>();
        for (int i = 0; i < appliances.length; ++i) {
            if (appliances[i].equals(appliance)) continue;
            list.add(appliances[i]);
        }
        return list.toArray(new Appliance[0]);
    }

    private Appliance[] getComponentGraph(Appliance appliance, boolean providers) {
        ArrayList result = new ArrayList();
        this.visitcomponent(appliance, providers, new ArrayList(), result);
        Appliance[] returnValue = new Appliance[result.size()];
        return result.toArray(returnValue);
    }

    private Appliance[] walkGraph(boolean direction) {
        ArrayList result = new ArrayList();
        ArrayList done = new ArrayList();
        int size = this.m_appliances.size();
        for (int i = 0; i < size; ++i) {
            Appliance appliance = (Appliance)this.m_appliances.get(i);
            this.visitcomponent(appliance, direction, done, result);
        }
        Appliance[] returnValue = new Appliance[result.size()];
        return result.toArray(returnValue);
    }

    private void visitcomponent(Appliance appliance, boolean direction, ArrayList done, ArrayList order) {
        if (done.contains(appliance)) {
            return;
        }
        done.add(appliance);
        if (direction) {
            this.visitProviders(appliance, done, order);
        } else {
            this.visitConsumers(appliance, done, order);
        }
        order.add(appliance);
    }

    private void visitProviders(Appliance appliance, ArrayList done, ArrayList order) {
        if (appliance instanceof Composite) {
            Appliance[] providers = ((Composite)((Object)appliance)).getProviders();
            for (int i = providers.length - 1; i > -1; --i) {
                this.visitcomponent(providers[i], true, done, order);
            }
        }
    }

    private void visitConsumers(Appliance appliance, ArrayList done, ArrayList order) {
        String name = appliance.getModel().getName();
        int size = this.m_appliances.size();
        for (int i = 0; i < size; ++i) {
            Appliance other = (Appliance)this.m_appliances.get(i);
            if (!(appliance instanceof Composite)) continue;
            Appliance[] providers = ((Composite)((Object)other)).getProviders();
            for (int j = 0; j < providers.length; ++j) {
                Appliance provider = providers[j];
                if (!provider.equals(appliance)) continue;
                this.visitcomponent(other, false, done, order);
            }
        }
        int childCount = this.m_children.size();
        for (int i = 0; i < childCount; ++i) {
            DependencyGraph map = (DependencyGraph)this.m_children.get(i);
            map.visitConsumers(appliance, done, order);
        }
    }
}

