/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.ref.Reference;
import org.apache.avalon.activation.ComponentFactory;
import org.apache.avalon.activation.impl.AbstractLifestyleManager;
import org.apache.avalon.composition.model.ComponentModel;

public class SingletonLifestyleManager
extends AbstractLifestyleManager {
    private Reference m_reference;

    public SingletonLifestyleManager(ComponentModel model, ComponentFactory factory) {
        super(model, factory);
    }

    public void commission() throws Exception {
        if (this.getComponentModel().getActivationPolicy()) {
            this.refreshReference();
        }
    }

    public void decommission() {
        if (this.m_reference != null) {
            this.finalize(this.m_reference.get());
            this.m_reference = null;
        }
    }

    protected synchronized Object handleResolve() throws Exception {
        Object instance = null;
        if (this.m_reference == null) {
            return this.refreshReference();
        }
        instance = this.m_reference.get();
        if (instance == null) {
            return this.refreshReference();
        }
        return instance;
    }

    protected synchronized void handleRelease(Object instance) {
    }

    public synchronized void finalize(Object instance) {
        this.getComponentFactory().etherialize(instance);
        this.m_reference = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object refreshReference() throws Exception {
        ComponentFactory factory;
        ComponentFactory componentFactory = factory = this.getComponentFactory();
        synchronized (componentFactory) {
            Object instance = factory.incarnate();
            this.m_reference = this.getReference(instance);
            return instance;
        }
    }
}

