/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.avalon.activation.ComponentFactory;
import org.apache.avalon.activation.LifecycleException;
import org.apache.avalon.activation.impl.DefaultServiceManager;
import org.apache.avalon.composition.info.DeliveryDescriptor;
import org.apache.avalon.composition.info.InjectorDeliveryDescriptor;
import org.apache.avalon.composition.info.NativeDeliveryDescriptor;
import org.apache.avalon.composition.info.NullDeliveryDescriptor;
import org.apache.avalon.composition.info.StagedDeliveryDescriptor;
import org.apache.avalon.composition.model.ComponentModel;
import org.apache.avalon.composition.model.ContextModel;
import org.apache.avalon.composition.model.ContextualizationHandler;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.LifecycleCreateExtension;
import org.apache.avalon.composition.model.LifecycleDestroyExtension;
import org.apache.avalon.composition.model.StageModel;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Executable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.lifecycle.Creator;
import org.apache.avalon.meta.info.StageDescriptor;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultComponentFactory
implements ComponentFactory {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$activation$impl$DefaultComponentFactory == null ? (class$org$apache$avalon$activation$impl$DefaultComponentFactory = DefaultComponentFactory.class$("org.apache.avalon.activation.impl.DefaultComponentFactory")) : class$org$apache$avalon$activation$impl$DefaultComponentFactory));
    private final SystemContext m_system;
    private final ComponentModel m_model;
    private final Logger m_logger;
    private final boolean m_secure;
    static /* synthetic */ Class class$org$apache$avalon$activation$impl$DefaultComponentFactory;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Startable;
    static /* synthetic */ Class class$org$apache$avalon$framework$activity$Executable;
    static /* synthetic */ Class class$org$apache$avalon$framework$logger$Logger;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configuration;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameters;
    static /* synthetic */ Class class$org$apache$avalon$framework$service$ServiceManager;
    static /* synthetic */ Class class$org$apache$avalon$lifecycle$Creator;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$LifecycleCreateExtension;
    static /* synthetic */ Class class$org$apache$avalon$composition$model$LifecycleDestroyExtension;

    public DefaultComponentFactory(SystemContext system, ComponentModel model) {
        this.m_system = system;
        this.m_model = model;
        this.m_secure = system.isCodeSecurityEnabled();
        this.m_logger = model.getLogger().getChildLogger("lifecycle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object incarnate() throws LifecycleException {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        ClassLoader classloader = this.m_model.getDeploymentClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classloader);
        try {
            Object object = this.incarnation();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void etherialize(Object instance) {
        try {
            this.applyCreateStage(instance, false);
        }
        catch (Throwable throwable) {
            block20: {
                String warning;
                Throwable e2;
                block19: {
                    Object var4_4 = null;
                    if (instance instanceof Startable) {
                        this.getLogger().debug("applying shutdown");
                        try {
                            if (this.m_secure) {
                                AccessController.doPrivileged(new PrivilegedExceptionAction(instance){
                                    private final /* synthetic */ Object val$instance;
                                    {
                                        this.val$instance = val$instance;
                                    }

                                    public Object run() throws Exception {
                                        ((Startable)this.val$instance).stop();
                                        return null;
                                    }
                                }, this.m_model.getAccessControlContext());
                            } else {
                                ContainerUtil.stop((Object)instance);
                            }
                        }
                        catch (Throwable e2) {
                            if (!this.getLogger().isWarnEnabled()) break block19;
                            warning = "Ignoring component source shutdown error.";
                            this.getLogger().warn("Ignoring component source shutdown error.", e2);
                        }
                    }
                }
                if (instance instanceof Disposable) {
                    this.getLogger().debug("applying disposal");
                    try {
                        if (this.m_secure) {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(instance){
                                private final /* synthetic */ Object val$instance;
                                {
                                    this.val$instance = val$instance;
                                }

                                public Object run() throws Exception {
                                    ((Disposable)this.val$instance).dispose();
                                    return null;
                                }
                            }, this.m_model.getAccessControlContext());
                        } else {
                            ContainerUtil.dispose((Object)instance);
                        }
                    }
                    catch (Throwable e2) {
                        if (!this.getLogger().isWarnEnabled()) break block20;
                        warning = "Ignoring component source disposal error.";
                        this.getLogger().warn("Ignoring component source disposal error.", e2);
                    }
                }
            }
            throw throwable;
        }
    }

    protected Logger getLogger() {
        return this.m_logger;
    }

    private Object incarnation() throws LifecycleException {
        Class clazz = this.m_model.getDeploymentClass();
        final Logger logger = this.m_model.getLogger();
        final Configuration config = this.m_model.getConfiguration();
        final Parameters params = this.m_model.getParameters();
        final DefaultServiceManager manager = new DefaultServiceManager(this.m_model);
        Object context = this.getTargetContext();
        Class contextClass = this.getContextCastingClass();
        final Object instance = this.instantiate(clazz, logger, config, params, context, contextClass, manager);
        try {
            DeliveryDescriptor delivery;
            if (instance instanceof LogEnabled) {
                this.getLogger().debug("applying logger");
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            ((LogEnabled)instance).enableLogging(logger);
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                } else {
                    ContainerUtil.enableLogging((Object)instance, (Logger)logger);
                }
            }
            if (this.m_model.getContextModel().isEnabled() && !((delivery = this.m_model.getContextModel().getDeliveryDescriptor()) instanceof NullDeliveryDescriptor) && !(delivery instanceof InjectorDeliveryDescriptor)) {
                this.applyContext(instance, delivery, context);
            }
            if (instance instanceof Serviceable) {
                this.getLogger().debug("applying service manager");
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ((Serviceable)instance).service(manager);
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                } else {
                    ContainerUtil.service((Object)instance, (ServiceManager)manager);
                }
            }
            if (instance instanceof Configurable) {
                this.getLogger().debug("applying configuration");
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ((Configurable)instance).configure(config);
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                } else {
                    ContainerUtil.configure((Object)instance, (Configuration)config);
                }
            }
            if (instance instanceof Parameterizable) {
                this.getLogger().debug("applying parameters");
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ((Parameterizable)instance).parameterize(params);
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                } else {
                    ContainerUtil.parameterize((Object)instance, (Parameters)params);
                }
            }
            this.applyCreateStage(instance, true);
            if (instance instanceof Initializable) {
                this.getLogger().debug("applying initialization");
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ((Initializable)instance).initialize();
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                } else {
                    ContainerUtil.initialize((Object)instance);
                }
            }
            if ((class$org$apache$avalon$framework$activity$Startable == null ? (class$org$apache$avalon$framework$activity$Startable = DefaultComponentFactory.class$("org.apache.avalon.framework.activity.Startable")) : class$org$apache$avalon$framework$activity$Startable).isAssignableFrom(clazz)) {
                this.getLogger().debug("applying statup");
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ((Startable)instance).start();
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                } else {
                    ContainerUtil.start((Object)instance);
                }
            } else if ((class$org$apache$avalon$framework$activity$Executable == null ? (class$org$apache$avalon$framework$activity$Executable = DefaultComponentFactory.class$("org.apache.avalon.framework.activity.Executable")) : class$org$apache$avalon$framework$activity$Executable).isAssignableFrom(clazz)) {
                this.getLogger().debug("applying execution");
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ((Executable)instance).execute();
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                } else {
                    ContainerUtil.execute((Object)instance);
                }
            }
            return instance;
        }
        catch (Throwable e) {
            String error = REZ.getString("lifestyle.error.new", (Object)this.m_model.getQualifiedName());
            throw new LifecycleException(error, e);
        }
    }

    private Class getContextCastingClass() {
        return this.m_model.getContextModel().getCastingClass();
    }

    private Object getTargetContext() {
        ContextModel model = this.m_model.getContextModel();
        if (null == model) {
            return null;
        }
        return model.getContext();
    }

    private Object instantiate(Class clazz, Logger logger, Configuration config, Parameters params, Object context, Class contextClass, ServiceManager manager) throws LifecycleException {
        Constructor constructor = this.getConstructor(clazz);
        Class<?>[] classes = constructor.getParameterTypes();
        Object[] args = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<?> c;
            if ((class$org$apache$avalon$framework$logger$Logger == null ? DefaultComponentFactory.class$("org.apache.avalon.framework.logger.Logger") : class$org$apache$avalon$framework$logger$Logger).isAssignableFrom(c = classes[i])) {
                if (null == logger) {
                    throw new NullPointerException("logger");
                }
                args[i] = logger;
                continue;
            }
            if (null != contextClass && contextClass.isAssignableFrom(c)) {
                if (null == context) {
                    throw new NullPointerException("context");
                }
                args[i] = context;
                continue;
            }
            if ((class$org$apache$avalon$framework$configuration$Configuration == null ? DefaultComponentFactory.class$("org.apache.avalon.framework.configuration.Configuration") : class$org$apache$avalon$framework$configuration$Configuration).isAssignableFrom(c)) {
                if (null == config) {
                    throw new NullPointerException("config");
                }
                args[i] = config;
                continue;
            }
            if ((class$org$apache$avalon$framework$parameters$Parameters == null ? DefaultComponentFactory.class$("org.apache.avalon.framework.parameters.Parameters") : class$org$apache$avalon$framework$parameters$Parameters).isAssignableFrom(c)) {
                if (null == params) {
                    throw new NullPointerException("params");
                }
                args[i] = params;
                continue;
            }
            if ((class$org$apache$avalon$framework$service$ServiceManager == null ? DefaultComponentFactory.class$("org.apache.avalon.framework.service.ServiceManager") : class$org$apache$avalon$framework$service$ServiceManager).isAssignableFrom(c)) {
                if (null == manager) {
                    throw new NullPointerException("manager");
                }
                args[i] = manager;
                continue;
            }
            String error = REZ.getString("lifecycle.error.unrecognized-parameter", (Object)c.getName(), (Object)clazz.getName());
            throw new LifecycleException(error);
        }
        return this.instantiateComponent(constructor, args);
    }

    private Constructor getConstructor(Class clazz) throws LifecycleException {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length < 1) {
            String error = REZ.getString("lifecycle.error.no-constructor", (Object)clazz.getName());
            throw new LifecycleException(error);
        }
        if (constructors.length > 1) {
            try {
                return clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                String error = "Multiple constructor ambiguity in the component model " + this.m_model + ". The component class [" + clazz.getName() + "] declares " + constructors.length + " public constructors.";
                throw new LifecycleException(error);
            }
        }
        return constructors[0];
    }

    private Object instantiateComponent(final Constructor constructor, final Object[] args) throws LifecycleException {
        try {
            if (args.length == 0) {
                this.getLogger().debug("instantiating component with a null constructor");
            } else {
                int n = args.length;
                this.getLogger().debug("instantiating component with " + n + " arguments.");
            }
            if (this.m_secure) {
                return AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return constructor.newInstance(args);
                    }
                }, this.m_model.getAccessControlContext());
            }
            return constructor.newInstance(args);
        }
        catch (Throwable e) {
            Class clazz = constructor.getDeclaringClass();
            String error = REZ.getString("lifecycle.error.instantiation", (Object)clazz.getName());
            throw new LifecycleException(error, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCreateStage(Object instance, boolean flag) throws LifecycleException {
        StageDescriptor[] stages = this.m_model.getType().getStages();
        if (stages.length > 0 && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("stage count: " + stages.length);
        }
        for (int i = 0; i < stages.length; ++i) {
            LifecycleCreateExtension handler;
            StageDescriptor stage;
            ComponentModel provider;
            Class c;
            block27: {
                if ((class$org$apache$avalon$lifecycle$Creator == null ? DefaultComponentFactory.class$("org.apache.avalon.lifecycle.Creator") : class$org$apache$avalon$lifecycle$Creator).isAssignableFrom(c = (provider = this.getStageProvider(stage = stages[i])).getDeploymentClass())) {
                    String error;
                    this.getLogger().debug("processing create: " + c.getName());
                    handler = this.getCreator((DeploymentModel)provider);
                    Context context = (Context)this.m_model.getContextModel().getContext();
                    try {
                        if (flag) {
                            if (this.getLogger().isDebugEnabled()) {
                                int id = System.identityHashCode(instance);
                                this.getLogger().debug("applying create stage to: " + id);
                            }
                            try {
                                handler.create(instance, context);
                                break block27;
                            }
                            catch (Throwable e) {
                                error = "Create stage error raised by extension.";
                                throw new LifecycleException("Create stage error raised by extension.", e);
                            }
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            int id = System.identityHashCode(instance);
                            this.getLogger().debug("applying destroy stage to: " + id);
                        }
                        handler.destroy(instance, context);
                    }
                    catch (Throwable e) {
                        error = REZ.getString("lifecycle.error.stage.creator", (Object)stage.getKey());
                        if (flag) {
                            throw new LifecycleException(error, e);
                        }
                        this.getLogger().warn(error, e);
                    }
                    finally {
                        provider.release((Object)handler);
                    }
                }
            }
            if (flag && (class$org$apache$avalon$composition$model$LifecycleCreateExtension == null ? DefaultComponentFactory.class$("org.apache.avalon.composition.model.LifecycleCreateExtension") : class$org$apache$avalon$composition$model$LifecycleCreateExtension).isAssignableFrom(c)) {
                handler = this.getLifecycleCreateExtension((DeploymentModel)provider);
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        int id = System.identityHashCode(instance);
                        this.getLogger().debug("applying model create stage to: " + id);
                    }
                    handler.create(this.m_model, stage, instance);
                    continue;
                }
                catch (Throwable e) {
                    String error = "Create stage extension error.";
                    throw new LifecycleException("Create stage extension error.", e);
                }
                finally {
                    provider.release((Object)handler);
                }
            }
            if (flag || !(class$org$apache$avalon$composition$model$LifecycleDestroyExtension == null ? DefaultComponentFactory.class$("org.apache.avalon.composition.model.LifecycleDestroyExtension") : class$org$apache$avalon$composition$model$LifecycleDestroyExtension).isAssignableFrom(c)) continue;
            handler = this.getLifecycleDestroyExtension((DeploymentModel)provider);
            try {
                if (this.getLogger().isDebugEnabled()) {
                    int id = System.identityHashCode(instance);
                    this.getLogger().debug("applying model destroy stage to: " + id);
                }
                handler.destroy(this.m_model, stage, instance);
                continue;
            }
            catch (Throwable e) {
                if (!this.getLogger().isWarnEnabled()) continue;
                String error = "Ignoring destroy stage error";
                this.getLogger().warn("Ignoring destroy stage error", e);
                continue;
            }
            finally {
                provider.release((Object)handler);
            }
        }
    }

    private Creator getCreator(DeploymentModel provider) throws LifecycleException {
        try {
            return (Creator)provider.resolve();
        }
        catch (Throwable e) {
            String error = "Unable to resolve creation stage provider.";
            throw new LifecycleException("Unable to resolve creation stage provider.", e);
        }
    }

    private LifecycleCreateExtension getLifecycleCreateExtension(DeploymentModel provider) throws LifecycleException {
        try {
            return (LifecycleCreateExtension)provider.resolve();
        }
        catch (Throwable e) {
            String error = "Unable to resolve lifecycle creation extension provider.";
            throw new LifecycleException("Unable to resolve lifecycle creation extension provider.", e);
        }
    }

    private LifecycleDestroyExtension getLifecycleDestroyExtension(DeploymentModel provider) throws LifecycleException {
        try {
            return (LifecycleDestroyExtension)provider.resolve();
        }
        catch (Throwable e) {
            String error = "Unable to resolve lifecycle destroy extension provider.";
            throw new LifecycleException("Unable to resolve lifecycle destroy extension provider.", e);
        }
    }

    private ComponentModel getStageProvider(StageDescriptor stage) throws IllegalStateException {
        String key = stage.getKey();
        StageModel model = this.m_model.getStageModel(stage);
        DeploymentModel provider = model.getProvider();
        if (provider instanceof ComponentModel) {
            return (ComponentModel)provider;
        }
        String error = REZ.getString("lifecycle.error.invalid-stage-provider", (Object)key);
        throw new IllegalStateException(error);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyContext(final Object instance, DeliveryDescriptor delivery, final Object context) throws LifecycleException {
        if (null == context) {
            return;
        }
        ContextModel model = this.m_model.getContextModel();
        if (delivery instanceof NativeDeliveryDescriptor) {
            this.getLogger().debug("applying context");
            if (!(context instanceof Context)) {
                String error = "Supplied context class [" + context.getClass().getName() + "] does not implement the Avalon Context interface.";
                throw new LifecycleException(error);
            }
            try {
                if (this.m_secure) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ((Contextualizable)instance).contextualize((Context)context);
                            return null;
                        }
                    }, this.m_model.getAccessControlContext());
                    return;
                }
                ContainerUtil.contextualize((Object)instance, (Context)((Context)context));
                return;
            }
            catch (Throwable e) {
                String error = REZ.getString("lifecycle.error.avalon-contextualization", (Object)this.m_model.getQualifiedName());
                throw new LifecycleException(error, e);
            }
        }
        if (!(delivery instanceof StagedDeliveryDescriptor)) {
            String error = "Unrecognized delivery strategy: [" + delivery.getClass().getName() + "].";
            throw new IllegalStateException(error);
        }
        this.getLogger().debug("applying custom context");
        DeploymentModel provider = model.getProvider();
        try {
            ContextualizationHandler handler = (ContextualizationHandler)provider.resolve();
            handler.contextualize(instance, (Context)context);
            return;
        }
        catch (Throwable e) {
            String error = REZ.getString("lifecycle.error.custom-contextualization", (Object)this.m_model.getQualifiedName(), (Object)provider.toString());
            throw new LifecycleException(error, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

