/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.activation.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.apache.avalon.activation.ApplianceRuntimeException;
import org.apache.avalon.activation.impl.AbstractAppliance;
import org.apache.avalon.activation.impl.BlockInvocationHandler;
import org.apache.avalon.composition.model.ContainmentModel;
import org.apache.avalon.composition.model.DeploymentModel;
import org.apache.avalon.composition.model.ServiceModel;
import org.apache.avalon.composition.provider.SystemContext;
import org.apache.avalon.composition.util.DefaultState;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.util.i18n.ResourceManager;
import org.apache.avalon.util.i18n.Resources;

public class DefaultBlock
extends AbstractAppliance {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$activation$impl$DefaultBlock == null ? (class$org$apache$avalon$activation$impl$DefaultBlock = DefaultBlock.class$("org.apache.avalon.activation.impl.DefaultBlock")) : class$org$apache$avalon$activation$impl$DefaultBlock));
    private final ContainmentModel m_model;
    private final SystemContext m_system;
    private final DefaultState m_commissioned = new DefaultState();
    private Object m_proxy;
    static /* synthetic */ Class class$org$apache$avalon$activation$impl$DefaultBlock;

    public DefaultBlock(SystemContext system, ContainmentModel model) throws ApplianceRuntimeException {
        super((DeploymentModel)model);
        this.m_model = model;
        this.m_system = system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commission() throws Exception {
        DefaultState defaultState = this.m_commissioned;
        synchronized (defaultState) {
            if (this.m_commissioned.isEnabled()) {
                return;
            }
            try {
                Logger log = this.m_model.getLogger().getChildLogger("proxy");
                BlockInvocationHandler handler = new BlockInvocationHandler(log, this);
                Class[] classes = this.getInterfaceClasses();
                this.m_proxy = Proxy.newProxyInstance(this.m_model.getClassLoaderModel().getClassLoader(), classes, (InvocationHandler)handler);
                this.m_commissioned.setEnabled(true);
            }
            catch (Throwable e) {
                String error = "Composite service establishment failure in block: " + this;
                throw new ApplianceRuntimeException(error, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decommission() {
        DefaultState defaultState = this.m_commissioned;
        synchronized (defaultState) {
            if (!this.m_commissioned.isEnabled()) {
                return;
            }
            if (null != this.m_proxy) {
                this.m_proxy = null;
            }
            this.m_commissioned.setEnabled(false);
        }
    }

    public Object resolve() throws Exception {
        if (!this.m_commissioned.isEnabled()) {
            String error = REZ.getString("block.error.resolve.non-commission-state", (Object)this.toString());
            throw new IllegalStateException(error);
        }
        return this.m_proxy;
    }

    public Object resolve(boolean proxy) throws Exception {
        return this.resolve();
    }

    public void release(Object instance) {
    }

    protected ContainmentModel getContainmentModel() {
        return this.m_model;
    }

    private Class[] getInterfaceClasses() throws Exception {
        ContainmentModel model = this.getContainmentModel();
        ClassLoader loader = model.getClassLoaderModel().getClassLoader();
        ArrayList<Class> list = new ArrayList<Class>();
        ServiceModel[] services = model.getServiceModels();
        for (int i = 0; i < services.length; ++i) {
            ServiceModel service = services[i];
            list.add(service.getServiceClass());
        }
        return list.toArray(new Class[0]);
    }

    public String toString() {
        return "block:" + this.getContainmentModel().getQualifiedName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

